function [KernelX,KernelY] = PredictionKernelDensity(PredPaths)
% PredictionKernelDensity: Calculates kernel density estimates of the marginal predictive distribution.
%
% USAGE:
%
%       [KernelX,KernelY] = PredictionKernelDensity(PredPaths)
%
% REQUIRED INPUT:  PredPaths (3D matrix) of dimension n x h x NumPaths of the n predicted
%                            variables over h periods, and with NumPaths paths.
%
% REQUIRED OUTPUT: KernelX (3D matrix) of dimension n x 2^8 x h with the x-axis values.
%
%                  KernelY (3D matrix) of dimension n x 2^8 x h with the y-axis values.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: March 2, 2009.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 03-03-2009: Added a test to make sure that the distribution is not contained
%               in a single point (conditioning assumption).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% initialize
%
[n,h,NumPaths] = size(PredPaths);
KernelX = zeros(n,2^8,h);
KernelY = KernelX;
%
% now we treat the data
%
for j=1:h;
   for i=1:n;
      TempVar = zeros(NumPaths,1);
      for p=1:NumPaths;
         TempVar(p,1) = PredPaths(i,j,p);
      end;
      if min(TempVar)+1.0e-8<max(TempVar);
         [x,f] = YADAMHDensEst(TempVar,2^8,0,'gaussian',[]);
         KernelX(i,:,j) = x';
         KernelY(i,:,j) = f';
      end;
      drawnow;
   end;
end;

%
% end of PredictionKernelDensity.m
%
