function out = StrSwap(in,old_str,new_str)
% StrSwap: Changes all occurances of old_str for new_str when old_str is preceeded by a mathematical or space character.
%
% USAGE:
%
%       out = StrSwap(in,old_str,new_str)
%
% REQUIRED INPUTS:  in (string) having some dimension 1xk
%                   old_str (string) having some dimension 1xk_old
%                   new_str (string) having some dimension 1xk_new
%
% REQUIRED OUTPUTS: out (string) having some dimension 1xm, where all occurances of old_str have been replaced with
%                       new_str provided that old_str is preceeded by a mathematical character. These are defined
%                       here as:
%
%                                   * ( + - ^ /
%
%                      and the SPACE character.
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: July 18, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-07-2006: Updated function information.
%
% * 07-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 21-10-2008: Added a test to ensure that the located "old_str" is not just the beginning of the
%               word being located, but actually the full word.
%
% * 29-10-2008: Made sure that the length of out is used rather than the length of in.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

out = in;
res = findstr(in,old_str);
k_old = length(old_str);
if isempty(res)==0;
   T = length(res);
   while T>=1;
      pos = res(1,T);
      %
      % check if we have a full word
      %
      CheckEndChar = 0;
      if length(in)>=pos+k_old;
         EndChar = in(1,pos+k_old);
         if isletter(EndChar)==0;
            CheckEndChar = 1;
         else;
            CheckEndChar = 0;
         end;
      else;
         CheckEndChar = 1;
      end;
      if CheckEndChar==1;
         if pos>1;
            %
            % check if pos-1 has a valid character
            %
            get_char = out(1,pos-1);
            if (strcmp(get_char,'*')==1)|(strcmp(get_char,'(')==1)|(strcmp(get_char,'+')==1)|(strcmp(get_char,'-')==1)|(strcmp(get_char,'^')==1)|(strcmp(get_char,'/')==1)|(strcmp(get_char,' ')==1);
               pre_str = out(1,1:pos-1);
               if pos+length(old_str)<length(out);
                  app_str = out(1,pos+length(old_str):length(out));
               else;
                  app_str = '';
               end;
               out = [pre_str new_str app_str];
            end;
         else;
            %
            % we have no pre_str
            %
            if pos+length(old_str)<length(out);
               app_str = out(1,pos+length(old_str):length(out));
            else;
               app_str = '';
            end;
            out = [pre_str new_str app_str];
         end;
      end;
      T = T-1;
   end;
end;

%
% end of StrSwap.m
%
