function outstr = Str2Matrix(instr,txtchar)
% Str2Matrix: transforms a string vector to a string matrix.
%
% USAGE:
%
%       outstr = Str2Matrix(instr,txtchar)
%
% REQUIRED INPUT:  instr (string vector)
%
% OPTIONAL INPUT:  txtchar (string), which defines the end of a word in instr.
%                          Default txtchar is $.
%
% REQUIRED OUTPUT: outstr (string matrix) with rows at most equal to the number of txtchar
%                          characters.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 1, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 07-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin==1;
   txtchar = '$';
end;

if (strcmp(instr,'')==1)|(isempty(instr)==1);
   outstr = '';
   return;
end;
%
% make sure instr only has 1 row
%
instr = instr(1,:);
t_vec = findstr(instr,txtchar);
if isempty(t_vec)==0;
   outstr = '';
   if t_vec(1)>1;
      outstr = instr(1,1:t_vec(1)-1);
   end;
   for i=2:length(t_vec);
      if t_vec(i-1)<=t_vec(i)-1;
         outstr = strvcat(outstr,instr(1,t_vec(i-1)+1:t_vec(i)-1));
      end;
   end;
else;
   outstr = instr;
end;

%
% end of Str2Matrix.m
%
