function ClockStr = SecondsToHoursStr(NumSec)
% SecondsToHoursStr: Translates seconds into hours, minutes and seconds.
%
% USAGE:
%
%       ClockStr = SecondsToHoursStr(NumSec)
%
% REQUIRED INPUT:  NumSec (positive real number) measuring the number of seconds (usually toc)
%
% REQUIRED OUTPUT: ClockStr (string vector) with (hrs:min:sec)
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 10, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 07-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

my_hrs = '00';
my_min = '00';
my_sec = num2str(NumSec,'%0.2f');
if NumSec>=60;
   ch_min = floor(NumSec/60);
   my_sec = num2str(NumSec-(ch_min*60),'%0.2f');
   my_min = num2str(ch_min,'%0.0f');
   if ch_min>=60;
      ch_hrs = floor(ch_min/60);
      my_min = num2str(ch_min-(ch_hrs*60),'%0.0f');
      my_hrs = num2str(ch_hrs,'%0.0f');
   end;
end;
if size(my_sec,2)==4;
   my_sec = ['0' my_sec];
end;
if size(my_min,2)==1;
   my_min = ['0' my_min];
end;
if size(my_hrs,2)==1;
   my_hrs = ['0' my_hrs];
end;
ClockStr = [my_hrs ':' my_min ':' my_sec];
      
%
% end of SecondsToHoursStr.m
%
