function out = RemoveIllegalChars(in)
% RemoveIllegalChars: removes characters that cannot appear in a filename under Windows,
%                      as well as a range of other non-alphanumeric characters.
%
% USAGE:
%
%       out = RemoveIllegalChars(in)
%
% REQUIRED INPUT:  in (string vector) that contains a filename that potentially has illegal
%                     characters. The following characters are viewed as illegal:
%
%                           \/*?@%&~^<>|!"':;`#$()[]{}=
%
% REQUIRED OUTPUT: out (string vector) where any illegal characters have been removed.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: July 25, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 18-08-2006: Changed the StrTrim function to StringTrim.
%
% * 07-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if strcmp(StringTrim(in),'')==1;
   out = '';
   return;
end;
out = strrep(in,'\','');
out = strrep(out,'/','');
out = strrep(out,'*','');
out = strrep(out,'?','');
out = strrep(out,'@','');
out = strrep(out,'%','');
out = strrep(out,'&','');
out = strrep(out,'~','');
out = strrep(out,'^','');
out = strrep(out,'<','');
out = strrep(out,'>','');
out = strrep(out,'!','');
out = strrep(out,'"','');
out = strrep(out,'''','');
out = strrep(out,':','');
out = strrep(out,';','');
out = strrep(out,'`','');
out = strrep(out,'','');
out = strrep(out,'|','');
out = strrep(out,'','');
out = strrep(out,'','');
out = strrep(out,'','');
out = strrep(out,'#','');
out = strrep(out,'','');
out = strrep(out,'$','');
out = strrep(out,'(','');
out = strrep(out,')','');
out = strrep(out,'[','');
out = strrep(out,']','');
out = strrep(out,'{','');
out = strrep(out,'}','');
out = strrep(out,'=','');

%
% end of RemoveIllegalChars.m
%
