function x = LocateStr(str,sstr,casedep)
% LocateStr: Locates a certain string vector in a string matrix
%
% USAGE:
%
%       x = LocateStr(str,sstr,casedep)
%
% REQUIRED INPUTS: str (string matrix)
%
%                  sstr (string vector)
%
% OPTIONAL INPUT:  casedep (boolean), if 1 it is case dependent (default), else 0
%
% REQUIRED OUTPUT: x (integer), with the row location of sstr in str. If no sstr is found,
%                    then x = 0.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 1, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 03-08-2006: Added the casedep optional argument.
%
% * 07-12-2006: Updated the documentation.
%
% * 07-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 23-07-2008: The function now makes sure that the string match.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin<3;
   casedep = 1;
end;
%
x = 0;
[n,n1] = size(str);
if casedep==1;
   for i=1:n;
      c_str = findstr(str(i,:),sstr(1,:));
      if (isempty(c_str)==0)&(c_str(1)==1);
         x = i;
         break;
      end;
   end;
else;
   for i=1:n;
      c_str = findstr(lower(str(i,:)),lower(sstr(1,:)));
      if (isempty(c_str)==0)&(c_str(1)==1);
         x = i;
         break;
      end;
   end;
end;

%
% LocateStr.m
%
