function CurrentDate = GetCurrentDate
% GetCurrentDate: provides the current month and day
%
% USAGE:
%
%       CurrentDate = GetCurrentDate
%
% REQUIRED OUTPUT: CurrentDate (string vector) with the current date.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: May 29, 2008.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 30-06-2008: Fixed a bug where '9', '10', '11' were all given by '1'.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% first the day
%
CurrentDate = StringTrim(datestr(now,7));
%
% and now the month
%
CurrMonth = StringTrim(datestr(now,5));
if (strcmp(CurrMonth,'1')==1)|(strcmp(CurrMonth,'01')==1);
   CurrentDate = ['January ' CurrentDate];
elseif (strcmp(CurrMonth,'2')==1)|(strcmp(CurrMonth,'02')==1);
   CurrentDate = ['February ' CurrentDate];
elseif (strcmp(CurrMonth,'3')==1)|(strcmp(CurrMonth,'03')==1);
   CurrentDate = ['March ' CurrentDate];
elseif (strcmp(CurrMonth,'4')==1)|(strcmp(CurrMonth,'04')==1);
   CurrentDate = ['April ' CurrentDate];
elseif (strcmp(CurrMonth,'5')==1)|(strcmp(CurrMonth,'05')==1);
   CurrentDate = ['May ' CurrentDate];
elseif (strcmp(CurrMonth,'6')==1)|(strcmp(CurrMonth,'06')==1);
   CurrentDate = ['June ' CurrentDate];
elseif (strcmp(CurrMonth,'7')==1)|(strcmp(CurrMonth,'07')==1);
   CurrentDate = ['July ' CurrentDate];
elseif (strcmp(CurrMonth,'8')==1)|(strcmp(CurrMonth,'08')==1);
   CurrentDate = ['August ' CurrentDate];
elseif (strcmp(CurrMonth,'9')==1)|(strcmp(CurrMonth,'09')==1);
   CurrentDate = ['September ' CurrentDate];
elseif strcmp(CurrMonth,'10')==1;
   CurrentDate = ['October ' CurrentDate];
elseif strcmp(CurrMonth,'11')==1;
   CurrentDate = ['November ' CurrentDate];
else;
   CurrentDate = ['December ' CurrentDate];
end;

%
% end of GetCurrentDate.m
%
