function z = StudentTRndFcn(mu,p,q,n,NumDraws)
% StudentTRndFcn: Draws a vector of random data from a univariate Student t distribution.
%
% USAGE:
%
%       z = StudentTRndFcn(mu,s,m,n,NumDraws)
%
% REQUIRED INPUT:  mu (vector) with means of the Student t distribution.
%
%                  p (vector) with a part of the variance of the Student t distribution.
%
%                  q (vector) with a part of the variance of the Student t distribution.
%
%                  n (integer) with the number of degrees of freedom.
%
% OPTIONAL INPUT:  NumDraws (integer) with the number of draws.
%
% REQUIRED OUTPUT: z (vector) with draws from the Student t distribution.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: February 6, 2007.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin<5;
   NumDraws = length(mu);
end;
NumDraws = floor(NumDraws);
if NumDraws<1;
   NumDraws = 1;
end;
%
% use the relationship between the student t and the normal and the inverse Gamma-2
%
z = mu+(randn(NumDraws,1) .* sqrt(InvGamma2RndFcn(p,n,NumDraws) ./ q ));

%
% end of StudentTRndFcn.m
%
