function z = LTNormalRndFcn(mu,sigma,c,NumDraws)
% LTNormalRndFcn: Draws matrices of data from the left truncated normal distribution..
%
% USAGE:
%
%       z = LTNormalRndFcn(mu,sigma,c,NumDraws)
%
% REQUIRED INPUT:  mu (vector) of means for the normal part.
%
%                  sigma (vector) of standard deviations for the normal part.
%
%                  c (vector) of lower bounds for z.
%
%                  NumDraws (integer) with the number of draws of z
%
% REQUIRED OUTPUT: z (matrix) of draws of dimension dim(mu) x NumDraws
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 28, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin<3;
   NumDraws = 1;
end;
NumDraws = floor(NumDraws);
if NumDraws<1;
   NumDraws = 1;
end;
%
%
z = zeros(length(mu),NumDraws);
%
for i=1:length(mu);
   %
   % initialize draws for variable i
   %
   zi = [];
   done = 0;
   while done==0;
      z1 = NormalRndFcn(mu(i),sigma(i),2*NumDraws-length(zi));
      zi = [zi z1(z1>=c(i))];
      if length(zi)>=NumDraws;
         zi = zi(1,1:NumDraws);
         done = 1;
      end;
   end;
   %
   % add zi to z
   %
   z(i,:) = zi;
end;

%
% end of LTNormalRndFcn.m
%
