function z = InvGamma2RndFcn(s,n,NumDraws)
% InvGamma2RndFcn: Draws a vector of random data from an inverse Gamma-2 distribution.
%
% USAGE:
%
%       z = InvGamma2RndFcn(s,n,NumDraws)
%
% REQUIRED INPUT:  s (vector) with the s parameter of the inverse Gamma-2 distribution.
%
%                  n (integer) with the second (degrees of freedom) parameter of the
%                    inverse Gamma-2 distribution.
%
% OPTIONAL INPUT:  NumDraws (integer) with the number of draws from the inverse Gamma-2.
%
% REQUIRED OUTPUT: z (vector) of dimension NumDraws with the draws taken from the inverse
%                    Gamma-2 distribution.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: February 6, 2007.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin<3;
   NumDraws = 1;
end;
NumDraws = floor(NumDraws);
if NumDraws<1;
   NumDraws = 1;
end;
%
% use the relationship between an inverse Gamma-2 distribution and the chi-squared
%
z = s ./ ChiSquareRndFcn(n,NumDraws);

%
% end of InvGamma2RndFcn.m
%
