function x = BetaRndFcn(a,b,c,d,NumDraws)
% BetaRndFcn: Draws matrices of data from the beta distribution.
%
% USAGE:
%
%       x = BetaRndFcn(a,b,c,d,NumDraws)
%
% REQUIRED INPUT:  a (vector) with the a parameter of the beta distribution.
%
%                  b (vector) with the b parameter of the beta distribution.
%
%                  c (vector) with the lower bound parameter of the beta distribution.
%
%                  d (vector) with the upper bound parameter of the beta distribution.
%
%                  NumDraws (integer) with the number of draws of z
%
% REQUIRED OUTPUT: x (matrix) of draws with dimension dim(a) x NumDraws
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 28, 2006.
%                        This version: January 22, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 29-8-2006:  Added a missing ; character in the betarnd call.
%
% * 9-11-2006:  Took the name change betarnd to YADAbetarnd into account.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 21-7-2008:  The function now checks if it should call the YADA version of "betarnd" or not.
%
% * 23-7-2008:  The function now takes the lower and upper bound parameters as input.
%
% * 22-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin<3;
   NumDraws = 1;
end;
NumDraws = floor(NumDraws);
if NumDraws<1;
   NumDraws = 1;
end;
if exist('YADAbetarnd')==2;
   z = YADAbetarnd(a,b,length(a),NumDraws);
else;
   z = betarnd(a,b,length(a),NumDraws);
end;
x = (c*ones(1,NumDraws))+(((d-c)*ones(1,NumDraws)).*z);

%
% end of BetaRndFcn.m
%
