function H = YADAbfgsi(H0,dg,dx)
% H = YADAbfgsi(H0,dg,dx)
% dg is previous change in gradient; dx is previous change in x;
% 6/8/93 version that updates inverse hessian instead of hessian
% itself.
% Copyright by Christopher Sims 1996.  This material may be freely
% reproduced and modified.
%
% NOTE:  YADAbfgsi is a minor rewrite of Christopher Sims' bfgsi function. The changes
%        only reflect some needs of YADA. The actual computations have not been changed. All disp
%        calls have been commented out.
%
%        First YADA version: August 9, 2006.
%
%


if size(dg,2)>1
   dg=dg';
end
if size(dx,2)>1
   dx=dx';
end
Hdg = H0*dg;
dgdx = dg'*dx;
if (abs(dgdx) >1e-12)
   H = H0 + (1+(dg'*Hdg)/dgdx)*(dx*dx')/dgdx - (dx*Hdg'+Hdg*dx')/dgdx;
else
%   disp('bfgs update failed.')
%   disp(['|dg| = ' num2str(sqrt(dg'*dg)) '|dx| = ' num2str(sqrt(dx'*dx))]);
%   disp(['dg''*dx = ' num2str(dgdx)])
%   disp(['|H*dg| = ' num2str(Hdg'*Hdg)])
   H=H0;
end
%save([pwd '\tmp\H.mat'],'H');

%
% end of YADAbfgsi.m
%
