function LogMarg = MargLikeLaplace(LogPost,InvHessian)
% MargLikeLaplace: Calculates the Laplace approximation of the log marginal likelihood.
%
% USAGE:
%
%       LogMarg = MargLikeLaplace(LogPost,InvHessian)
%
% where the Laplace approximation is based on a multivariate normal approximation, evluated at the posterior
% mode. This means that for a parameter vector of dimension k:
%
%          LogMarg = LogPost + (k/2)*log(2*pi) + (1/2)*log(det(InvHessian))
%
% where InvHessian is the inverse of the Hessian at the posterior mode.
%
%
% REQUIRED INPUT:  LogPost (scalar) with the value of the log posterior at the posterior mode.
%
%                  InvHessian (pxp matrix) with the inverse Hessian at the posterior mode.
%
% REQUIRED OUTPUT: LogMarg (scalar) with the value of the log marginal likelihood under the Laplace
%                          approximation.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: October 20, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

LogMarg = LogPost+((length(InvHessian)/2)*log(2*pi))+((1/2)*log(det(InvHessian)));

%
% end of MargLikeLaplace.m
%
