function Names = YADASymvar(FcnStr)
% YADASymvar: provides the variable names in the same order as in the function string.
%
% USAGE:
%
%       Names = YADASymvar(FcnStr)
%
% REQUIRED INPUT:  FcnStr (string vector) that is sent to the inline function.
%
% REQUIRED OUTPUT: Names (cell array of strings) with the names of the variables found in the
%                        function string.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 20, 2008.
%                        This version: January 21, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 28-8-2008:  Updated the documentation.
%
% * 18-9-2008:  Fixed a bug for the NamesOrder variable. New method instead of using findstr in FcnStr string.
%               The former leads to false positives, while new method is precise.
%
% * 21-02-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

Names = argnames(inline(FcnStr));
if isempty(Names)==1;
   return;
end;
NamesOrder = zeros(length(Names),1);
%
% remove mathematical characters from function string
%
fcnStr = strrep(FcnStr,'+',' ');
fcnStr = strrep(fcnStr,'-',' ');
fcnStr = strrep(fcnStr,'/',' ');
fcnStr = strrep(fcnStr,'*',' ');
fcnStr = strrep(fcnStr,'[',' ');
fcnStr = strrep(fcnStr,'(',' ');
fcnStr = strrep(fcnStr,')',' ');
fcnStr = strrep(fcnStr,']',' ');
fcnStr = strrep(fcnStr,'''',' ');
fcnStr = strrep(fcnStr,';',' ');
fcnStr = strrep(fcnStr,'.',' ');
fcnStr = strrep(fcnStr,',',' ');
fcnStr = strrep(fcnStr,':',' ');
fcnStr = strrep(fcnStr,'{',' ');
fcnStr = strrep(fcnStr,'}',' ');
FcnMat = Str2Matrix([fcnStr ' '],' ');
for i=1:length(Names);
   for j=1:size(FcnMat,1);
      if strcmp(Names{i},StringTrim(FcnMat(j,:)))==1;
         NamesOrder(i) = j;
         break;
      end;
   end;
end;
[Pos,Ind] = sort(NamesOrder);
Names = Names(Ind);

%
% end of YADASymvar.m
%
