function OutMatrix = ReplaceData(InMatrix,OldValue,NewValue)
% ReplaceData: replaces data values in a matrix.
%
% USAGE:
%
%       OutMatrix = ReplaceData(InMatrix,OldValue,NewValue)
%
% REQUIRED INPUT:  InMatrix (nxm) matrix.
%
%                  OldValue (scalar) value to replace.
%
%                  NewValue (scalar) value to replace OldValue with.
%
% REQUIRED OUTPUT: OutMatrix (nxm) matrix where all instances of OldValue in InMatrix has
%                            been replaced with NewValue
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: Januart 25, 2007.
%                        This version: January 21, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 21-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

OutMatrix = InMatrix;
if isempty(InMatrix)==1;
   return;
end;
[n,m] = size(InMatrix);
for i=1:n;
   %
   % create indices
   %
   IndexVector = (OutMatrix(i,:)==OldValue) .* (1:m);
   IndexVector = IndexVector(IndexVector>0);
   if isempty(IndexVector)==0;
      OutMatrix(i,IndexVector) = NewValue;
   end;
end;

%
% end of ReplaceData.m
%
