function D = DuplicationMatrix(m)
% DuplicationMatrix: Creates the 0-1 duplication matrix.
%
% USAGE:
%
%       D = DuplicationMatrix(m)
%
% REQUIRED INPUT:  m (integer).
%
% REQUIRED OUTPUT D (m^2xm(m+1)/2) duplication matrix.
%
% NOTE: The duplication matrix, D, is a 0-1 matrix such that for any symmetric matrix A:
%
%              vec(A) = D*vech(A)
%
% where vech is the operator which only stacks elements on and below of the diagonal of A.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: Januart 30, 2007.
%                        This version: January 21, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 21-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

D = zeros(m*m,m*(m+1)/2);
dmel2 = 0;
for j=1:m;
   for i=1:m-j+1;
      dmel2 = dmel2+1;
      D(i+(m+1)*(j-1),dmel2) = 1;
   end;
end;
if m > 1;
   for j=1:m-1;
      dmstar = 1;
      for i=1:j;
         D(i+m*j,dmstar+j-i+1) = 1;
         dmstar = dmstar+m-i+1;
      end;
   end;
end;

%
% End of DuplicationMatrix.m
%
