function OutMatrix = AnnSumMatrix(m,q)
% AnnSumMatrix: Creates an mx(m-q+1) 0-1 matrix where each column has q consecutive unit elements
%               starting in row 1,2, ..., m-q+1.
%
% USAGE:
%
%       OutMatrix = AnnSumMatrix(m,q)
%
% REQUIRED INPUT:  m (integer) with the number of rows.
%
%                  q (integer) with the number of 1's per column.
%
% REQUIRED OUTPUT: OutMatrix (mxm-q+1) 0-1 matrix.
%
% NOTE: This function is used when annualizing quarterly or monthly growth rates. An example for
%       quarterly growth rate:
%
%         AnnMatrix(10,4)
%
% produces:
%
%           1 0 0 0 0 0 0
%           1 1 0 0 0 0 0
%           1 1 1 0 0 0 0
%           1 1 1 1 0 0 0
%           0 1 1 1 1 0 0
%           0 0 1 1 1 1 0
%           0 0 0 1 1 1 1
%           0 0 0 0 1 1 1
%           0 0 0 0 0 1 1
%           0 0 0 0 0 0 1
%
% When postmultiplying a rx10 matrix with this, 4 consecutive observations of the matrix will be added.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: January 22, 2007.
%                        This version: January 21, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 21-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

OutMatrix = zeros(m,m-q+1);
for i=1:m-q+1;
   OutMatrix(i:q+i-1,i) = ones(q,1);
end;

%
% end of AnnSumMatrix.m
%
