function status = VerifySteadyStatePrior(File,SelectedVariables,SelectedXVariables)
% VerifySteadyStatePrior: Tests if the prior file for the steady state prior is valid.
%
% USAGE:
%
%       status = VerifySteadyStatePrior(File,SelectedVariables,SelectedXVariables)
%
% REQUIRED INPUT:  File (string vector) with the full path+filename for the steady state prior file.
%
%                  SelectedVariables (vector) with integers representing the endogenous variables to
%                                     use in the BVAR.
%
%                  SelectedXVariables (vector) with integers representing the endogenous variables to
%                                     use in the BVAR.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: January 12, 2007.
%                        This version: March 9, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-03-2007: Updated the documentation.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
% * 09-03-2009: Added quotation marks around paths for the dos copy command.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

status = 0;
if FileExist(File)==0;
   return;
end;
if strcmp(lower(GetExt(File)),'.m')==0;
   return;
end;
%
% Prior file is OK. Do we have enough selected variables
%
if isempty(SelectedVariables)==1;
   return;
end;
%
% copy the prior file to the tmp directory
%
[stat,msg] = dos(['copy /Y "' File '" "' pwd '\tmp"']);
%
% try to run the steady state prior file
%
try;
   eval(['PriorMatrix = ' GetName(File) '(SelectedVariables,SelectedXVariables);']);
catch;
   return;
end;
if isempty(PriorMatrix)==1;
   return;
end;
if (size(PriorMatrix,1)~=length(SelectedVariables)*length(SelectedXVariables))|(size(PriorMatrix,2)~=2);
   return;
end;
%
% The prior matrix has the correct dimension. Check if all
% elements of the second column of PriorMatrix are positive 
%
if sum(PriorMatrix(:,2)>0)==length(SelectedVariables)*length(SelectedXVariables);
   status = 1;
end;

%
% end of VerifySteadyStatePrior.m
%
