function status = VerifyPosteriorModeEstimation(DSGEModel)
% VerifyPosteriorModeEstimation: Verifies if the information in the DSGEModel structure used by YADA is sufficient
%                                to attempt estimation of the model.
%
% USAGE:
%
%       status = VerifyPosteriorModeEstimation(DSGEModel)
%
% REQUIRED INPUT:  DSGEModel (structure) with fields containing the DSGE model data.
%
% REQUIRED OUTPUT: status (boolean), is equal to 1 if the DataConstructionFile, the MeasurementEquationFile, the
%                         PriorFile, the AIMFile, and the AIMDataFile exists, and if the vectors StateShockPositions
%                         and StateVariablePositions are non-empty. The function otherwise returns 0.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 3, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 4-8-2006:   Updated the documentation.
%
% * 24-8-2006:  Updated the documentation.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
% * 19-12-2008: Added the check for the compute_aim_matrices file. The function no longer checks for the
%               existence of the prior file.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

status = 0;
if FileExist(DSGEModel.AIMDataFile)==0;
   return;
end;
if (FileExist(DSGEModel.AIMFile)==0)&(FileExist([GetPath(DSGEModel.AIMDataFile) 'compute_aim_matrices.m'])==0);
   return;
end;
if FileExist(DSGEModel.DataConstructionFile)==0;
   return;
end;
if FileExist(DSGEModel.MeasurementEquationFile)==0;
   return;
end;
%if FileExist(DSGEModel.PriorFile)==0;
%   return;
%end;
if isempty(DSGEModel.StateShockPositions)==1;
   return;
end;
if isempty(DSGEModel.StateVariablePositions)==1;
   return;
end;
status = 1;

%
% end of VerifyPosteriorModeEstimation.m
%
