function status = PredictionsExist(OutputDirectory,ModelStr,CondStr,ShockMethod,NameOfModel,MaxPH,NumDraws,NumPredPaths,AnnualizeData,TransData,CurrChain)
% PredictionsExist: Tests is all the results for the predictive distributions exist on disk.
%
% USAGE:
%
%       status = PredictionsExist(OutputDirectory,ModelStr,CondStr,ShockMethod,NameOfModel,MaxPH,NumDraws,NumPredPaths,AnnualizeData,TransData,CurrChain)
%
% REQUIRED INPUT:  OutputDirectory (string vector) with the full path to the base output directory.
%
%                  ModelStr (string vector) that is either "DSGE" or "BVAR".
%
%                  CondStr (string vector) that is either "Cond" or "".
%
%                  ShockMethod (string vector) that is either "Direct-", "WaggonerZha-", or "".
%
%                  NameOfModel (string vector) with the name of the model.
%
%                  MaxPH (integer) with the length of the prediction horizon.
%
%                  NumDraws (integer) with the total number of parameter draws.
%
%                  NumPredPaths (integer) with tht total number of prediction paths per parameter draw.
%
%                  AnnualizeData (boolean) that take the value 1 if annualized results should be checked and 0 otherwise.
%
%                  TransData (boolean) that is 1 if the prediction paths should be transformed and 0 otherwise.
%
%                  CurrChain (integer) with the number for the current Markov chain.
%
% REQUIRED OUTPUT: status (boolean) that is 1 if the results exist on disk and 0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: February 23, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 12-3-2007:  Added the input "CondStr" to test for conditional predictive distributions.
%
% * 13-11-2007: Updated the documentation.
%
% * 18-12-2007: Added the input "ShockMethod".
%
% * 19-12-2007: Made sure that "ShockMethod" can be an empty string.
%
% * 5-5-2008:   Added the input variable "TransData".
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

status = 0;
for ParamIndex=1:NumDraws;
   if AnnualizeData==0;
      if TransData==0;
         file = [OutputDirectory '\predictions\' ModelStr '-' CondStr 'Prediction-Original-' ShockMethod NameOfModel '-' num2str(CurrChain,'%0.0f') '-' num2str(MaxPH,'%0.0f') '-' num2str(ParamIndex,'%0.0f') '.' num2str(NumDraws,'%0.0f') '.' num2str(NumPredPaths,'%0.0f') '.mat'];;
      else;
         file = [OutputDirectory '\predictions\' ModelStr '-' CondStr 'Prediction-Transformed-' ShockMethod NameOfModel '-' num2str(CurrChain,'%0.0f') '-' num2str(MaxPH,'%0.0f') '-' num2str(ParamIndex,'%0.0f') '.' num2str(NumDraws,'%0.0f') '.' num2str(NumPredPaths,'%0.0f') '.mat'];;
      end;
   else;
      file = [OutputDirectory '\predictions\' ModelStr '-' CondStr 'Prediction-Annual-' ShockMethod NameOfModel '-' num2str(CurrChain,'%0.0f') '-' num2str(MaxPH,'%0.0f') '-' num2str(ParamIndex,'%0.0f') '.' num2str(NumDraws,'%0.0f') '.' num2str(NumPredPaths,'%0.0f') '.mat'];;
   end;
   if FileExist(file)==0;
      return;
   end;
end;
status = 1;

%
% end of PredictionsExist.m
%
