function stat = IsWinXP
% IsWinXP: Tests if Matlab is run on a Windows XP computer.
%
% USAGE:
%
%       stat = IsWinXP
%
% REQUIRED OUTPUT: stat (boolean). Returns 1 if you are running Windows XP, and 0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 21, 2006.
%                        This version: December 9, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 8-12-2008:  Added the quotes around the call to exe-files.
%
% * 9-12-2008:  Removed quotes around the directory parameter for the iswinxp.exe call.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

file = [pwd '\iswinxp.txt'];
if FileExist(file)==1;
   txt = ReadText(file);
   if min(size(txt))==1;
      txt = txt{1};
      txt = strrep(txt,' ','');
      stat = str2double(txt);
      if isnumeric(stat)==1;
         return;
      end;
   end;
end;

stat = 0;
if strcmp(computer,'PCWIN')==1;
   prog = ['"' pwd '\bin\iswinxp.exe" ' pwd];
   stat_e = dos(prog);
   if FileExist(file)==1;
      txt = ReadText(file);
      if min(size(txt))==1;
         txt = txt{1};
         txt = strrep(txt,' ','');
         stat = str2double(txt);
         if isnumeric(stat)==0;
            stat = 0;
         end;
      end;
   else;
      fid = fopen(file,'wt');
      fprintf(fid,'0\n');
      fclose(fid);
   end;
end;

%
% end of IsWinXP.m
%
