function Status = IsAlmostEqual(varargin)
% IsAlmostEqual: Tests if arrays are almost equal, i.e., the absolute difference
%                is less than 0.00001. If the number of inputs exceeds 2, then the
%                function is the same is the isequal function in matlab.
%
% USAGE:
%
%       Status = IsAlmostEqual(x1,x2,...)
%
% REQUIRED INPUT:  x1 (matrix) of dimension T1xK1.
%
%                  x2 (matrix) of diemsnion T2xK2.
%
% OPTIONAL INPUT:  x3 (matrix) of dimension T3xK3, etc.
%
% REQUIRED OUTPUT: Status (boolean) that takes on the value 1 if all the inputs are almost
%                         equal and 0 otherwise.
%                          
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European central Bank.
%
%                       First version: August 23, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

Status = isequal(varargin{:});
if (Status==0)&(nargin==2)&(size(varargin{1})==size(varargin{2}))&(isnumeric(varargin{1}))&(isnumeric(varargin{2}));
   if max(max(abs(varargin{1}-varargin{2})))<1.0e-005;
      Status = 1;
   end;
end;

%
% end of IsAlmostEqual.m
%
