function y=siqr(x)

% SIQR        Sample Interquartile Range. 
%
%             SIQR(X) calculates the sample interquarile range (IQR) of X.
%
%             Christian C. Beardah 1995

n=length(x);

[order index]=sort(x);

mlo=ceil(n/4);
mhi=ceil(3*n/4);

if mlo>0 & mlo<n,
  zlo=(order(mlo)+order(mlo+1))/2;
end;

if mhi>0 & mhi<n,
  zhi=(order(mhi)+order(mhi+1))/2;
end;

y = zhi - zlo;
