function w=pclevel(p,density)

% PCLEVEL     Calculates p% contour density.
%
%             PCLEVEL(P,DENSITY) calculates contour levels for the
%             percentages in P and the (pre-calculated) densities 
%             in DENSITY.
%
%             Christian C. Beardah 1994

r=density; 

n=length(r);

w=zeros(n,2);

p=100-p;

[order index]=sort(r);

m=ceil(n*p/100);

for i=1:length(p),
  if m(i)==0,
    v=0.9*order(1); 
  end;

  if m(i)>0 & m(i)<n,
    v=(order(m(i))+order(m(i)+1))/2;
  end;

  if m(i)==n,
    v=(order(n-1)+order(n))/2;
  end;

  w(i,:)=[v v];

end;