function k=knorm(x,y,z)

% KNORM       Uni-, Bi- or Tri-variate Normal Density Function.

if nargin==3,
  s=x.*x+y.*y+z.*z;
  elseif nargin==2,
    s=x.*x+y.*y;
    else,
      s=x.*x;
end;
 
k=(2*pi)^(-nargin/2)*exp(-0.5*s);           