function [y,h]=kdest1d(x,A,k,h)

% KDEST1D     Uni-variate Kernel Density Estimator.
%
%             Examples: load kddata
%                       x=0:10:500;
%                       y=kdest1d(x,suicide,'kepan',0);
%                       plot(x,y)
%
%             KDEST1D(X,A,K,H) evaluates a uni-variate Kernel Density 
%             Estimate with kernel given by the function in K.
%             'KNORM' is the uni-variate normal distribution.
%             'KEPAN' is the Epanechnikov kernel.
%             'KBIWE' is the Bi-weight kernel.
%             'KTRIA' is the Triangular kernel.
%             'KRECT' is the Rectanguler kernel. 
%             See Silverman (1986) page 76 for details. 
%
%             X is the point for which the density estimate is required.
%             The uni-variate data points are stored row by row in A.
%
%             The parameter H represents the window width.  If H=0 an 'optimal' 
%             value is used (STE rule).
%
%             Christian C. Beardah 1994-95

if nargin==3,
  h=0;
end;

n=length(A); % Establish dimensions of A,

if h==0, % If no value of h has been specified then calculate one
%  h=hns(A,k);
  h=hste(A,k);
end;

my_sum = 0;
for i=1:n;
   if strcmp(k,'knorm')==1;
      temp = knorm((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'kepan')==1;
      temp = kepan((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'krect')==1;
      temp = krect((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'ktria')==1;
      temp = ktria((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'kbiwe')==1;
      temp = kbiwe((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'ktriw')==1;
      temp = ktriw((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'klapl')==1;
      temp = klapl((x-A(i,:)*ones(size(x)))/h);
   elseif strcmp(k,'klogi')==1;
      temp = klogi((x-A(i,:)*ones(size(x)))/h);
   end;
   my_sum = my_sum+temp;
end;

%my_sum=feval(k,(x-A(1,:)*ones(size(x)))/h);

%for i=2:n, % sum over all data points
%  my_sum=my_sum+feval(k,(x-A(i,:)*ones(size(x)))/h);
%end;

y=my_sum/(n*h); % y holds the k.d. estimate values corresponding 
             % to the points in x.

