function h=hns(A,k)

% HNS         Basic Normal Scale estimate of smoothing parameter.
%
%             Examples: load kddata
%                       h=hns(suicide,'kepan');
%
%             HNS(A,K) evaluates an 'optimal' value of h for use 
%             with uni-variate data A and with kernel given by the 
%             function in K.
%             'KNORM' is the uni-variate normal distribution.
%             'KEPAN' is the Epanechnikov kernel.
%             'KBIWE' is the Bi-weight kernel.
%             'KTRIW' is the Tri-weight kernel.
%             'KTRIA' is the Triangular kernel.
%             'KRECT' is the Rectanguler kernel. 
%             'KLAPL' is the Laplace kernel.
%             'KLOGI' is the Logistic kernel.
%             See Silverman (1986) page 76 for details. 
%
%             Christian C. Beardah 1994-95

n=length(A);

if k=='knorm', % Normal kernel
  a=1.0592;
  elseif k=='kepan', % Epanechnikov kernel
    a=2.34;
    elseif k=='kbiwe', % Bi-weight kernel
      a=2.7779;
      elseif k=='ktria', % Triangular
        a=2.5760;
        elseif k=='krect', % Rectangular
          a=1.8431;
          elseif k=='klapl', % Laplace
            a=0.7836;
            elseif k=='ktriw', % Triweight
              a=3.1545;
              elseif k=='klogi', % Logistic
                a=0.5921;
end;

if siqr(A)>0,
  s=min([std(A) siqr(A)/1.34]);
  else,
    s=std(A);
end;

h=a*s*n^(-1/5);
