function [y4,y6,y8,y10]=deriv(t,k)

% DERIV       4th, 6th, 8th and 10th derivatives of the Normal kernel.
%
%             Example: [y4,y6,y8,y10]=deriv(0,'knorm')
%
%             DERIV(T,K) finds the derivatives of the kernel K 
%             at the point T.  (Only normal kernel supported.)
%
%             Christian C. Beardah 1995

if k=='knorm',
  y4=(t.^4-6*t.^2+3).*exp(-0.5*t.^2)/sqrt(2*pi);
  if nargout>1,
    y6=(t.^6-15*t.^4+45*t.^2-15).*exp(-0.5*t.^2)/sqrt(2*pi);  
  end;
  if nargout>2;
    y8=(t.^8-28*t.^6+210*t.^4-420*t.^2+105).*exp(-0.5*t.^2)/sqrt(2*pi);
  end;
  if nargout>3,
    y10=(t.^10-45*t.^8+630*t.^6-3150*t.^4+4725*t.^2-945).*exp(-0.5*t.^2)/sqrt(2*pi);
  end;
end;