function [y,h,hl]=akdest1d(x,A,k,h)

% AKDEST1D    Adaptive Kernel Density Estimator for uni-variate data.
%
%             AKDEST1D(X,A,K,H) evaluates the uni-variate Adaptive Kernel 
%             Density Estimate with kernel given by the function in K.
%
%             'KNORM' is the univariate normal kernel.
%             'KEPAN' is the Epanechnikov kernal.
%
%             X: The point for which we want the density estimate.
%             A: The single column of data.
%             H: The optional parameter H represents the window width.
%                If omitted an 'optimal' value (calculated using the STE 
%                rule) is used.
%
%             Christian C. Beardah 1994

if nargin==3,
  h=0;
end;

[n d]=size(A); % Establish dimensions of A

if h==0,
%  h=hns(A,k);
   h=hste(A,k);
%  if n<=400,
%    h=0.26*n^(-0.042);
%    else,
%      h=0.58*n^(-0.364);
%  end;
end;

s=0;
alpha=1/d;

[f,h]=kdest1d(A,A,k,h);

l=log(f);
t=sum(l);

g=exp(t/n);

lambda=(f/g).^(-alpha);
hl=h*lambda;


for i=1:n;
   if strcmp(k,'knorm')==1;
      temp = knorm((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'kepan')==1;
      temp = kepan((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'krect')==1;
      temp = krect((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'ktria')==1;
      temp = ktria((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'kbiwe')==1;
      temp = kbiwe((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'ktriw')==1;
      temp = ktriw((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'klapl')==1;
      temp = klapl((x-A(i,:)*ones(size(x)))/hl(i));
   elseif strcmp(k,'klogi')==1;
      temp = klogi((x-A(i,:)*ones(size(x)))/hl(i));
   end;
   s = s+hl(i)^(-d)*temp;
end;


%s=s+hl(1)^(-d)*feval(k,(x-A(1,:)*ones(size(x)))/hl(1));

%for i=2:n,
%  s=s+hl(i)^(-d)*feval(k,(x-A(i,:)*ones(size(x)))/hl(i));
%end;

y=s/n; 