function CurrentINI = InitializeINIFile
% InitializeINIFile: Initializes various settings for YADA including some that can be changed by the user.
%
% USAGE:
%
%       CurrentINI = InitializeINIFile
%
% REQUIRED OUTPUT: CurrentINI (structure) whose fields provide the values of the various settings.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 21, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 9-8-2006:   Added documentation, and the fields "StepLengthHessian", "NumberOfGridPoints", "FiniteDifferenceHessian",
%               "CheckOptimum"
%
% * 11-8-2006:  Changed the default values of certain paper related figure properties.
%
% * 15-8-2006:  Added the fields "GridWidth" and "IRHorizon".
%
% * 23-8-2006:  Changed the default values for "xtick" and "ytick" to 1.
%
% * 29-8-2006:  Added the "PosteriorDrawsValue", "SampleBatchValue" and "ParallelChainsValue" fields.
%
% * 30-8-2006:  Added the fields "BurnInValue", "MHInitialScaleFactor", "MHScaleFactor", "RandomWeightValue".
%
% * 31-8-2006:  Added the fields "PriorKernel", "KernelDensityValue", and "KernelDensityEstimator".
%
% * 20-10-2006: Added the field "CheckTransformedOptimum".
%
% * 24-11-2006: Changed the default values for ygrad, and zgrid to 1.
%
% * 28-11-2006: The fields "PosteriorDrawsValue", "SampleBatchValue", "ParallelChainsValue", "BurnInValue",
%               "MHInitialScaleFactor", "MHScaleFactor", and "RandomWeightValue" are no loonger in the CurrentINI
%               structure. They have instead been included in the DSGEModel structure.
%
% * 7-12-2006:  The fields "MaximumIterationsValue", "ToleranceValue", "MaximizeAlgorithmValue", "StepLengthHessian",
%               "NumberOfGridPoints", "FiniteDifferenceHessian", "CheckOptimum", "CheckTransformedOptimum", "GridWidth",
%               "IRHorizon", "PriorKernel", "KernelDensityValue", and "KernelDensityEstimator" are no longer held in
%               the CurrenINI structure. They have been moved to the DSGEModel structure.
%
% * 7-3-2007:   Added the field "graphicsfmt".
%
% * 7-11-2007:  Updated the documentation.
%
% * 9-11-2007:  Changed the value of the field "text_backgroundcolor".
%
% * 26-3-2008:  Added the outputs "FontAngle" and "FontWeight" from the call to "GetUIFont".
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

CurrentINI.colors = 0;
CurrentINI.landscape = 0;
CurrentINI.paperposmode = 'manual';
CurrentINI.papertype = 'a4';
CurrentINI.portmanteau = 0;
CurrentINI.xgrid = 0;
CurrentINI.box = 1;
CurrentINI.ygrid = 1;
CurrentINI.zgrid = 1;
CurrentINI.sillyq = 0;
CurrentINI.graphicsfmt = 'eps';
CurrentINI.paperunits = 'centimeters';
CurrentINI.text_fontname = 'Courier new';
CurrentINI.text_fontsize = 10;
CurrentINI.axes_fontname = 'Arial';
CurrentINI.axes_fontsize = 8;
CurrentINI.title_fontname = 'Arial';
CurrentINI.title_fontsize = 9;
CurrentINI.label_fontname = 'Arial';
CurrentINI.label_fontsize = 8;
CurrentINI.text_fontweight = 'normal';
CurrentINI.text_fontangle = 'normal';
CurrentINI.text_fontunits = 'points';
CurrentINI.text_color = [0 0 0];
%CurrentINI.text_backgroundcolor = [1 1 0.69412];
CurrentINI.text_backgroundcolor = [0.98 0.98 0.98];
CurrentINI.axes_fontweight = 'normal';
CurrentINI.axes_fontangle = 'normal';
CurrentINI.axes_fontunits = 'points';
CurrentINI.axes_color = [0 0 0];
CurrentINI.title_fontweight = 'normal';
CurrentINI.title_fontangle = 'normal';
CurrentINI.title_fontunits = 'points';
CurrentINI.title_color = [0 0 0];
CurrentINI.label_fontweight = 'normal';
CurrentINI.label_fontangle = 'normal';
CurrentINI.label_fontunits = 'points';
CurrentINI.label_color = [0 0 0];
CurrentINI.random_state = 1;
CurrentINI.nRep = 10000;
CurrentINI.nDraw = 500;
CurrentINI.invert_hardcopy = 1;
CurrentINI.center_value = 6;
CurrentINI.fill_value = 6;
CurrentINI.crop_image = 0;
CurrentINI.edit_context = 0;
CurrentINI.z_buffer = 0;
CurrentINI.use_toolbar_bgcolor = 0;
CurrentINI.gui_light_color = [1 1 1];
CurrentINI.gui_shade_color = [0.5 0.5 0.5];
CurrentINI.gui_dark_color = [0 0 0];
CurrentINI.ytick = 1;
CurrentINI.xtick = 1;
CurrentINI.tempdir = '';
CurrentINI.browsedialog = 0;
[FontName,FontSize,FontAngle,FontWeight] = GetUIFont;
CurrentINI.gui_fontname = FontName;
CurrentINI.gui_fontsize = FontSize;
CurrentINI.gui_fontangle = FontAngle;
CurrentINI.gui_fontweight = FontWeight;
CurrentINI.gui_font = 0;
CurrentINI.frame_color = [0.50196 0 0];
CurrentINI.frame_light_color = [1 1 1];
CurrentINI.frame_shade_color = [0.5 0.5 0.5];
CurrentINI.frame_dark_color = [0 0 0];
CurrentINI.gui_foreground_color = [0 0 0.4];
CurrentINI.decimals = 6;
CurrentINI.progress_facecolor = (1/255)*[166 210 255];
CurrentINI.progress_edgecolor = [0 0 0];
CurrentINI.progress_bgcolor = [1 1 1];
CurrentINI.progress_startfacecolor = (1/255)*[0 36 104];

%
% end of InitializeINIFile.m
%
