function SetXTickIntegers(AxesHandle)
% SetXTickIntegers: sets the xlabel ticks to intgeger values only.
%
% USAGE:
%
%       SetXTickIntegers(AxesHandle)
%
% REQUIRED INPUT: AxesHandle (handle) to an axis object.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: November 9, 2007.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 11-1-2008:  Made sure that "XTickMode" is always set to "manual".
%
% * 14-1-2008:  If the difference between the max and the min of XTick is less than
%               6, then unit ticks are given.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% check if we need to fix the X ticks
%
set(AxesHandle,'XTickMode','manual');
XTick = get(AxesHandle,'XTick');
XTickCheck = 0;
if length(XTick)>1;
   if (IsInteger(XTick(2)-XTick(1))==1)&(max(XTick)-min(XTick)>=6);
      XTickCheck = 1;
   end;
else;
   if IsInteger(XTick(1))==1;
      XTickCheck = 1;
   end;
end;
if XTickCheck==1;
   %
   % no need to fix anything
   %
   return;
end;
%
% create the new XTick vector and XTickLabel string matrix
%
NewXTick = (ceil(XTick(1)):1:floor(XTick(length(XTick))));
%
% set the new features on the axes
%
set(AxesHandle,'XTick',NewXTick);

%
% end of SetXTickIntegers.m
%
