function SetToolbarImages(FigHandle,ImageStructure)
% SetToolbarImages: Sets images for the main toolbar on plots. It also changes the callback for
%                   the "open file" toolbar button and the "open" uimenu label.
%
% USAGE:
%
%       SetToolbarImages(FigHandle,ImageStructure)
%
% REQUIRED INPUT: FigHandle (handle) to a figure.
%
%                 ImageStructure (structure), whose fields contain the image cdata information.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 29, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 9-11-2007:  Added the "editplot" button.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

PushTool = findall(FigHandle,'Type','uipushtool');
if (isempty(PushTool)==0)&(ishandle(PushTool(1))==1);
   %
   % we can locate the uipushtool buttons on the toolbar
   %
   for i=1:length(PushTool);
      if strcmp(lower(get(PushTool(i),'TooltipString')),'open file')==1;
         set(PushTool(i),'ClickedCallback','OpenGraphics','CData',ImageStructure.viewgraphics)
      end;
      if strcmp(lower(get(PushTool(i),'TooltipString')),'save figure')==1;
         set(PushTool(i),'CData',ImageStructure.save)
      end;
      if strcmp(lower(get(PushTool(i),'TooltipString')),'new figure')==1;
         set(PushTool(i),'CData',ImageStructure.new)
      end;
      if strcmp(lower(get(PushTool(i),'TooltipString')),'print figure')==1;
         set(PushTool(i),'CData',ImageStructure.print)
      end;
   end;
end;
ToggleTool = findall(FigHandle,'Type','uitoggletool');
if (isempty(ToggleTool)==0)&(ishandle(ToggleTool(1))==1);
   %
   % we can now locate the uitoggletoll buttons on the toolbar
   %
   for i=1:length(ToggleTool);
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'zoom in')==1;
         set(ToggleTool(i),'CData',ImageStructure.zoomin);
      end;
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'zoom out')==1;
         set(ToggleTool(i),'CData',ImageStructure.zoomout);
      end;
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'rotate 3d')==1;
         set(ToggleTool(i),'CData',ImageStructure.rotate3d);
      end;
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'add arrow')==1;
         set(ToggleTool(i),'CData',ImageStructure.arrow);
      end;
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'add text')==1;
         set(ToggleTool(i),'CData',ImageStructure.text);
      end;
      if strcmp(lower(get(ToggleTool(i),'TooltipString')),'add line')==1;
         set(ToggleTool(i),'CData',ImageStructure.line);
      end;
      if (strcmp(lower(get(ToggleTool(i),'TooltipString')),'enable plot editing')==1)|(strcmp(lower(get(ToggleTool(i),'TooltipString')),'edit plot')==1);
         set(ToggleTool(i),'CData',ImageStructure.editplot);
      end;
   end;
end;
%
% Try to locate the uimenu for open file. If found, change its callback.
%
FigMenu = findall(FigHandle,'Type','uimenu','Accelerator','O');
if (isempty(FigMenu)==0)&(ishandle(FigMenu)==1);
   set(FigMenu(1),'Callback','OpenGraphics');
end;

%
% end of SetToolbarImages.m
%
