function SetFigureProperties(FigureHandle,CurrINI)
% SetFigureProperties: Sets a number of figure properties
%
% USAGE:
%
%       SetFigureProperties(FigureHandle,CurrINI)
%
% REQUIRED INPUTS: FigureHandle (handle) to a matlab figure.
%
%                  CurrINI (structure) with initialization information.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: 15 August, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 23-8-2007:  Updated the documentation.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if CurrINI.landscape==1;
   orientstr = 'landscape';
else;
   orientstr = 'portrait';
end;
if CurrINI.invert_hardcopy==1;
   inv_hardcopy = 'on';
else;
   inv_hardcopy = 'off';
end;
if CurrINI.z_buffer==1;
   renderer = 'zbuffer';
else;
   renderer = 'painters';
end;
%
% setting the current figure properties
%
if ishandle(FigureHandle)==1;
   set(FigureHandle,'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
         'NumberTitle','off', ...
         'Renderer',renderer, ...
         'PaperUnits',CurrINI.paperunits, ...
         'PaperOrientation',orientstr, ...
         'PaperPositionMode',CurrINI.paperposmode, ...
         'PaperType',CurrINI.papertype, ...
         'InvertHardcopy',inv_hardcopy);
   %
   if MatlabNumber>=7.0;
      set(FigureHandle,'DockControl','off');
   end;
   %
   % obey centering and filling defaults
   %
   CenterFillFigure(FigureHandle,CurrINI.fill_value,CurrINI.center_value);
end;

%
% end of SetFigureProperties.m
%
