function SetAxesFonts(CurrINI,varargin)
% SetAxesFonts: Sets titles and labels in graphs.
%
% USAGE:
%
%       SetAxesFonts(CurrINI,'Title',titlestr,'XLabel',xlabelstr,'YLabel',ylabelstr,'ZLabel',zlabelstr)
%
% or
%
%       SetAxesFonts(CurrINI,LegendHandle)
%
% or
%
%       SetAxesFonts(CurrINI,ColorbarHandle)
%
% REQUIRED INPUTS: CurrINI (structure) with initialization information.
%
% OPTIONAL INPUTS: 'Title',titlestr (string vectors) where the first input indicates that the title
%                                   for the axes object should be set to titlestr.
%
%                  'XLabel',xlabelstr (string vectors) where the first input indicates that the
%                                   xlabel for the axes object should be set to xlabelstr.
%
%                  'YLabel',ylabelstr (string vectors) where the first input indicates that the
%                                   ylabel for the axes object should be set to ylabelstr.
%
%                  'ZLabel',zlabelstr (string vectors) where the first input indicates that the
%                                   zlabel for the axes object should be set to zlabelstr.
%
%                  LegendHandle (handle) for a legend. These objects have the Tag "legend".
%
%                  ColorbarHandle (handle) for a colorbar. These object have the Tag "colorbar".
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: 11 August, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 23-8-2007:  Removed some unnecessary code and added all the documentation.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% inserting text and fixing fonts and colors
%
if ischar(varargin{1})==1;
   %
   % taking care of the axes
   %
   set(gca,'FontSize',CurrINI.axes_fontsize, ...
           'FontName',CurrINI.axes_fontname, ...
           'FontWeight',CurrINI.axes_fontweight, ...
           'FontAngle',CurrINI.axes_fontangle, ...
           'FontUnits',CurrINI.axes_fontunits, ...
           'XColor',CurrINI.axes_color, ...
           'YColor',CurrINI.axes_color, ...
           'ZColor',CurrINI.axes_color);
   if CurrINI.xgrid==1;
      set(gca,'XGrid','on');
   else;
      set(gca,'XGrid','off');
   end;
   if CurrINI.ygrid==1;
      set(gca,'YGrid','on');
   else;
      set(gca,'YGrid','off');
   end;
   if CurrINI.zgrid==1;
      set(gca,'ZGrid','on');
   else;
      set(gca,'ZGrid','off');
   end;
   if CurrINI.box==1;
      set(gca,'Box','on');
   else;
      set(gca,'Box','off');
   end;
   num = round(size(varargin,2)/2);
   for i=1:num;
      k = 1+2*(i-1);
      if ischar(varargin{k})==1;
         if strcmp(lower(varargin{k}),'title')==1;
            title(varargin{k+1});
         elseif strcmp(lower(varargin{k}),'xlabel')==1;
            xlabel(varargin{k+1});
         elseif strcmp(lower(varargin{k}),'ylabel')==1;
            ylabel(varargin{k+1});
         elseif strcmp(lower(varargin{k}),'zlabel')==1;
            zlabel(varargin{k+1});
         end;
      end;
   end;
   set(get(gca,'Title'),'FontSize',CurrINI.title_fontsize, ...
                        'FontName',CurrINI.title_fontname, ...
                        'FontWeight',CurrINI.title_fontweight, ...
                        'FontAngle',CurrINI.title_fontangle, ...
                        'FontUnits',CurrINI.title_fontunits, ...
                        'Color',CurrINI.title_color);
   set(get(gca,'XLabel'),'FontSize',CurrINI.label_fontsize, ...
                         'FontName',CurrINI.label_fontname, ...
                         'FontWeight',CurrINI.label_fontweight, ...
                         'FontAngle',CurrINI.label_fontangle, ...
                         'FontUnits',CurrINI.label_fontunits, ...
                         'Color',CurrINI.label_color);
   set(get(gca,'YLabel'),'FontSize',CurrINI.label_fontsize, ...
                         'FontName',CurrINI.label_fontname, ...
                         'FontWeight',CurrINI.label_fontweight, ...
                         'FontAngle',CurrINI.label_fontangle, ...
                         'FontUnits',CurrINI.label_fontunits, ...
                         'Color',CurrINI.label_color);
   set(get(gca,'Zlabel'),'FontSize',CurrINI.label_fontsize, ...
                         'FontName',CurrINI.label_fontname, ...
                         'FontWeight',CurrINI.label_fontweight, ...
                         'FontAngle',CurrINI.label_fontangle, ...
                         'FontUnits',CurrINI.label_fontunits, ...
                         'Color',CurrINI.label_color);
elseif ishandle(varargin{1})==1;
   thish = varargin{1};
   if strcmp(get(thish,'Tag'),'legend')==1;
      text_h = findobj(thish,'Type','text');
      for i0=1:size(text_h,1);
         set(text_h(i0,1),'FontName',CurrINI.axes_fontname);
         set(text_h(i0,1),'FontSize',CurrINI.axes_fontsize);
         set(text_h(i0,1),'FontWeight',CurrINI.axes_fontweight);
         set(text_h(i0,1),'FontAngle',CurrINI.axes_fontangle);
         set(text_h(i0,1),'FontUnits',CurrINI.axes_fontunits);
         set(text_h(i0,1),'Color',CurrINI.axes_color);
      end;
   elseif strcmp(get(thish,'Tag'),'colorbar')==1;
      set(thish,'FontSize',CurrINI.axes_fontsize, ...
              'FontName',CurrINI.axes_fontname, ...
              'FontWeight',CurrINI.axes_fontweight, ...
              'FontAngle',CurrINI.axes_fontangle, ...
              'FontUnits',CurrINI.axes_fontunits, ...
              'XColor',CurrINI.axes_color, ...
              'YColor',CurrINI.axes_color);
   end;
end;

%
% end of SetAxesFonts.m
%
