function NewBarHandles = RemakeBars(BarHandles,GroupColors,BlackEdgeBars)
% RemakeBars: Takes input from a vector of handles created using the bar function with the property
%             'stack'. Bars with negative values are displayed below 0, and those with positive above
%             such that all bars can be seen.
%
% USAGE:
%
%       NewBarHandles = RemakeBars(BarHandles,GroupColors)
%
% REQUIRED INPUT:  BarHandles (vector), with b handles to patch objects.
%
%                  GroupColors (bx3 matrix) with colors for the b handles BarHandles
%
% OPTIONAL INPUT:  BlackEdgeBars (boolean) that takes on the value 1 if
%                                the EdgeColor property should be black, and
%                                0 otherwise.
%
% REQUIRED OUTPUT: NewBarHandles (vector), with handles to patch objects.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: December 5, 2006.
%                        This version: January 25, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 5-1-2007:   Made sure the colors of the bars are based on the user selections (if there are any). This is dealt
%               with through the GroupColors input.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 14-8-2008:  Changed the edge color from the GroupColors(i,:) value to "none".
%
% * 19-12-2008: Updated the documentation.
%
% * 25-02-2009: Added the optional input "BlackEdgeBars".
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin==2;
   BlackEdgeBars = 0;
end;
%
for i=1:length(BarHandles);
   Data(i).XData = get(BarHandles(i),'XData');
   Data(i).YData = get(BarHandles(i),'YData');
   Data(i).ZData = get(BarHandles(i),'ZData');
   Data(i).CData = get(BarHandles(i),'CData');
   Data(i).CDataMapping = get(BarHandles(i),'CDataMapping');
   Data(i).AmbientStrength = get(BarHandles(i),'AmbientStrength');
   Data(i).BackFaceLighting = get(BarHandles(i),'BackFaceLighting');
   Data(i).DiffuseStrength = get(BarHandles(i),'DiffuseStrength');
   Data(i).EdgeLighting = get(BarHandles(i),'EdgeLighting');
   Data(i).FaceLighting = get(BarHandles(i),'FaceLighting');
   Data(i).SpecularColorReflectance = get(BarHandles(i),'SpecularColorReflectance');
   Data(i).SpecularExponent = get(BarHandles(i),'SpecularExponent');
   Data(i).SpecularStrength = get(BarHandles(i),'SpecularStrength');
   Data(i).Clipping = get(BarHandles(i),'Clipping');
   Data(i).FaceColor = GroupColors(i,:); % get(BarHandles(i),'FaceColor');
   if BlackEdgeBars==0;
      Data(i).EdgeColor = 'none'; % get(BarHandles(i),'EdgeColor');
   else;
      Data(i).EdgeColor = [0 0 0];
   end;
   Data(i).LineStyle = get(BarHandles(i),'LineStyle');
   Data(i).LineWidth = get(BarHandles(i),'LineWidth');
   Data(i).Marker = get(BarHandles(i),'Marker');
   Data(i).MarkerSize = get(BarHandles(i),'MarkerSize');
   Data(i).MarkerFaceColor = get(BarHandles(i),'MarkerFaceColor');
   Data(i).MarkerEdgeColor = get(BarHandles(i),'MarkerEdgeColor');
   Data(i).Tag = get(BarHandles(i),'Tag');
end;
T = size(Data(1).YData,2);
for t=1:T;
   IndNeg = 0;
   IndPos = 0;
   if Data(1).YData(1,t)>Data(1).YData(2,t);
      IndNeg = Data(1).YData(2,t)-Data(1).YData(1,t);
   else;
      IndPos = Data(1).YData(2,t)-Data(1).YData(1,t);
   end;
   for i=2:length(BarHandles);
      if Data(i).YData(1,t)>Data(i).YData(2,t);
         %
         % it's a negative value
         %
         AddOn = IndNeg+Data(i).YData(2,t)-Data(i).YData(1,t);
         Data(i).YData(:,t) = [AddOn IndNeg IndNeg AddOn]';
         IndNeg = AddOn;
      else;
         %
         % it's a positive value
         %
         AddOn = IndPos+Data(i).YData(2,t)-Data(i).YData(1,t);
         Data(i).YData(:,t) = [IndPos AddOn AddOn IndPos]';
         IndPos = AddOn;
      end;
   end;
end;
bh = length(BarHandles);
NewBarHandles = zeros(size(BarHandles));
delete(BarHandles);
for i=1:bh;
   NewBarHandles(i) = patch('XData',Data(i).XData, ...
                     'YData',Data(i).YData, ...
                     'ZData',Data(i).ZData, ...
                     'CData',Data(i).CData, ...
                     'CDataMapping',Data(i).CDataMapping, ...
                     'AmbientStrength',Data(i).AmbientStrength, ...
                     'BackFaceLighting',Data(i).BackFaceLighting, ...
                     'DiffuseStrength',Data(i).DiffuseStrength, ...
                     'EdgeLighting',Data(i).EdgeLighting, ...
                     'FaceLighting',Data(i).FaceLighting, ...
                     'SpecularColorReflectance',Data(i).SpecularColorReflectance, ...
                     'SpecularExponent',Data(i).SpecularExponent, ...
                     'SpecularStrength',Data(i).SpecularStrength, ...
                     'Clipping',Data(i).Clipping, ...
                     'FaceColor',Data(i).FaceColor, ...
                     'EdgeColor',Data(i).EdgeColor, ...
                     'LineStyle',Data(i).LineStyle, ...
                     'LineWidth',Data(i).LineWidth, ...
                     'Marker',Data(i).Marker, ...
                     'MarkerSize',Data(i).MarkerSize, ...
                     'MarkerFaceColor',Data(i).MarkerFaceColor, ...
                     'MarkerEdgeColor',Data(i).MarkerEdgeColor, ...
                     'Tag',Data(i).Tag);
   hold('on');
end;

%
% end of RemakeBars.m
%
