function [XValues,YValues] = KernelDensityPlot(X,InterPolateOption)
% KernelDensityPlot: Creates x and y vectors of values for plotting a density function using a Kernel
%                    Density estimator.
%
% USAGE:
%
%       [XValues,YValues] = KernelDensityPlot(X,InterPolateOption)
%
% REQUIRED INPUT:  X (vector) of values for a random variable.
%
%                  InterPolateOption (string vector), that takes on one of the following values:
%
%                          knorm:   normal kernel
%                          kepan:   Epanechnikov
%                          krect:   rectangular
%                          ktria:   triangular
%                          kbiwe:   bi-weight
%                          ktriw:   tri-weight
%                          klapl:   Laplace
%                          klogi:   logistic
%
% REQUIRED OUTPUT: XValues (vector) with 512 values for the X axis.
%
%                  YValues (vector) with 512 value for the Y axis.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 29, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

xmin = min(X);
xmax = max(X);
xrange = xmax-xmin;
ax = xmin-xrange/4;
bx = xmax+xrange/4;
if strcmp(InterPolateOption,'knorm')==1;
   h = 0;
else;
   h = hns(X,InterPolateOption);
end;
[XValues,YValues] = kdfft1(X,InterPolateOption,512,h,0,[ax,bx]);
YValues = (1/max(cdf(XValues,YValues)))*YValues;
XValues = XValues';

%
% end of KernelDensityPlot.m
%
