function GroupColors = CreateDefaultColors(NumColors)
% CreateDefaultColors: Creates default colors based on the default colormap (jet)
%
% USAGE:
%
%       GroupColors = CreateDefaultColors(NumColors)
%
% REQUIRED INPUT:  NumColors (positive integer) with the number of colors.
%
% REQUIRED OUTPUT: GroupColors (NumColorsx3) matrix with color numbers, i.e., numbers between 0 and 1.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: January 5, 2007.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-3-2007:  Updated the documentation.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

GroupColors = zeros(NumColors,3);
%
% create a figure
%
fig = figure('Visible','off','Position',[0 0 800 600]);
DataVec = ones(NumColors*2,1)*(1:NumColors);
if MatlabNumber>=7.0;
   %
   % make sure the bars are written as patches
   %
   BarHandles = bar('v6',DataVec,'stacked');
else;
   BarHandles = bar(DataVec,'stacked');
end;
for i=1:length(BarHandles);
   if isnumeric(get(BarHandles(i),'FaceColor'))==1;
      GroupColors(i,:) = get(BarHandles(i),'FaceColor');
   else;
      %
      % colors are defined by CData, CLim
      %
      IntValue = get(BarHandles(i),'CData');
      clim = caxis;
      CurrMap = colormap;
      if strcmp(get(BarHandles(i),'CDataMapping'),'scaled')==1;
         %
         % the CDataMapping is scaled (this should be the default)
         %
         index = min(fix((IntValue(1,1)-clim(1))/(clim(2)-clim(1))*length(CurrMap))+1,length(CurrMap));
      else;
         %
         % the CDataMazpping is direct
         %
         index = min(IntValue(1,1),length(CurrMap));
      end;
      GroupColors(i,:) = CurrMap(index,:);
   end;
end;
close(fig);

%
% end of CreateDefaultColors.m
%
