function TextGUIResize
% TextGUIResize: Resize function for the TextGUI made window.
%
% USAGE:
%
%       TextGUIResize
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 25, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 2-4-2008:   Added the move of the TextControls.print control.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

TextDLG = get(0,'CurrentFigure');
TextControls = get(TextDLG,'UserData');
position = get(TextDLG,'Position');
CurrINI = get(TextControls.done,'UserData');
%
% fix positions
%
boxpos = [2 2 position(3)-2 position(4)-10];
ud = get(TextControls.text,'UserData');
boxtext = ud.boxtext;
boxwidth = ud.boxwidth;
delete(TextControls.box);
boxpos(3) = max(boxpos(3),10);
boxpos(4) = max(boxpos(4),10);
TextControls.box = AxesBox(boxpos,boxtext,boxwidth,[0.5 1],'on',CurrINI);
set(TextControls.text,'Position',[15 54 max(position(3)-30,1) max(position(4)-78,1)]);
set(TextControls.done,'Position',[position(3)-105 20 90 20]);
if isfield(TextControls,'print')==1;
   set(TextControls.print,'Position',[position(3)-205 20 90 20]);
end;
set(TextDLG,'UserData',TextControls);

%
% end of TextGUIResize.m
%
