function DataStructure = TabDialog(DataStructure,CurrINI,TabDLGPosition,NumTabs,TabInputStruc,ButtonWidths)
% TabDialog: Creates a tabbed dialog.
%
% USAGE:
%
%       DataStructure = TabDialog(DataStructure,CurrINI,TabDLGPosition,NumTabs,TabInputStruc,ButtonWidths)
%
% REQUIRED INPUT:  DataStructure (structure) with handles which may be empty.
%
%                  CurrINI (structure) with initialization information.
%
%                  TabDLGPosition (vector) with the position of the tabbed dialog.
%
%                  NumTabs (integer) with the number of tabs.
%
%                  TabInputStruc (structure) with the following fields:
%                                fldnames:    (cell array) with field names for the tabs.
%                                tags:        (cell array) with tags names for the tabs.
%                                strings:     (cell array) with text for the tabs.
%                                callbackstr: (cell array) with callbacks for the tabs.
%                                visible:     (cell array) with strings having values "on" or "off".
%
%                  ButtonWidths (vector) of diemsnion 2 with the width of the button for the shown tab
%                                and hidden tabs repsectively.
%
% REQUIRED OUTPUT: DataStructure (structure) a structure containing all handles of the created
%                          objects+any handles passed to the function.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 24, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-5-2008:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

fig = get(0,'CurrentFigure');
%
fixed = 0;
if MatlabNumber>=6.0;
   fixed = 1;
end;
%
% color vectors
%
darkvec = [0 0 0];
shadevec = [0.5 0.5 0.5];
lightvec = [1 1 1];
%
if isempty(CurrINI)==0;
   if isfield(CurrINI,'gui_light_color')==1;
      lightvec = CurrINI.gui_light_color;
   end;
   if isfield(CurrINI,'gui_shade_color')==1;
      shadevec = CurrINI.gui_shade_color;
   end;
   if isfield(CurrINI,'gui_dark_color')==1;
      darkvec = CurrINI.gui_dark_color;
   end;
end;
%
% the bottom x axis
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1) TabDLGPosition(2) TabDLGPosition(3) 1], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',darkvec, ...
   'YColor',darkvec, ...
   'ZColor',darkvec);
%
% shading the bottom x axis up
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1)+1 TabDLGPosition(2)+1 TabDLGPosition(3)-1 1], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',shadevec, ...
   'YColor',shadevec, ...
   'ZColor',shadevec);
%
% the left y axis
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1) TabDLGPosition(2)+1 1 TabDLGPosition(4)], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',lightvec, ...
   'YColor',lightvec, ...
   'ZColor',lightvec);
%
% the top x axis
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1)+1 TabDLGPosition(2)+TabDLGPosition(4)+fixed TabDLGPosition(3)-1 1], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',lightvec, ...
   'YColor',lightvec, ...
   'ZColor',lightvec);
%
% shading the right y axis left
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1)+TabDLGPosition(3)-1 TabDLGPosition(2)+1 1 TabDLGPosition(4)-1], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',shadevec, ...
   'YColor',shadevec, ...
   'ZColor',shadevec);
%
% the right y axis
%
axes('Units','pixels', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1)+TabDLGPosition(3) TabDLGPosition(2) 1 TabDLGPosition(4)+1], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','gui', ...
   'XColor',darkvec, ...
   'YColor',darkvec, ...
   'ZColor',darkvec);
%
% removing a few pixels
%
if MatlabNumber>=6.0;
   axes('Units','pixels', ...
      'TickLength',[0 0], ...
      'CameraUpVector',[0 1 0], ...
      'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
      'Position',[TabDLGPosition(1)+TabDLGPosition(3)+1 TabDLGPosition(2) 2 2], ...
      'XTickLabelMode','manual', ...
      'YTickLabelMode','manual', ...
      'Tag','gui', ...
      'XColor',get(0,'defaultuicontrolbackgroundcolor'), ...
      'YColor',get(0,'defaultuicontrolbackgroundcolor'), ...
      'ZColor',get(0,'defaultuicontrolbackgroundcolor'));
end;
%
btn_1_width = ButtonWidths(1);
btn_2_width = ButtonWidths(2);
btn_mean = (btn_1_width+btn_2_width)/2;
%
% create the first tab
%
h_btn = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'ForegroundColor',[0 0 0], ...
         'Position',[TabDLGPosition(1) TabDLGPosition(2)+TabDLGPosition(4)-2 btn_1_width 25], ...
         'String',TabInputStruc.strings{1}, ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Visible',TabInputStruc.visible{1}, ...
         'Enable','on', ...
         'UserData',1, ...
         'Callback',TabInputStruc.callbackstr{1}, ...
         'Tag',TabInputStruc.tags{1});
%
temp_btns = h_btn;
%
if (isempty(DataStructure)==1)|(isstruct(DataStructure)==0);
   DataStructure = struct(TabInputStruc.fldnames{1},h_btn);
else;
   DataStructure = setfield(DataStructure,TabInputStruc.fldnames{1},h_btn);
end;
%
% create the frames
%
DataStructure.frame1tab1 = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'ForegroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[TabDLGPosition(1) TabDLGPosition(2)+TabDLGPosition(4)-10 btn_1_width 11], ...
   'Style','frame', ...
   'Tag','frame1tab1');
%
DataStructure.frame2tab1 = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'ForegroundColor',lightvec, ...
   'Position',[TabDLGPosition(1) TabDLGPosition(2)+TabDLGPosition(4)-10 1 11], ...
   'Style','frame', ...
   'Tag','frame2tab1');
%
DataStructure.frame3tab1 = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'ForegroundColor',lightvec, ...
   'Position',[TabDLGPosition(1) TabDLGPosition(2)+TabDLGPosition(4) btn_1_width 1], ...
   'Style','frame', ...
   'Visible','off', ...
   'Tag','frame3tab1');
%
% create the other tabs
%
old_curr_row = 1;
add_height = 0;
for i=2:NumTabs;
   if i<=6;
      sub_val = 0;
      if i==2;
         sub_val = 1;
         btn_val = 0;
      else;
         btn_val = btn_val+btn_mean;
      end;
      %
      h_btn = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'ForegroundColor',[0 0 0], ...
         'Position',[TabDLGPosition(1)+btn_1_width+btn_val TabDLGPosition(2)+TabDLGPosition(4)-2 btn_2_width 23], ...
         'String',TabInputStruc.strings{i}, ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Visible',TabInputStruc.visible{i}, ...
         'Enable','on', ...
         'Callback',TabInputStruc.callbackstr{i}, ...
         'Tag',TabInputStruc.tags{i});
       %
       temp_btns = [temp_btns h_btn];
       %
       % store the handle in the output structure.
       %
       DataStructure = setfield(DataStructure,TabInputStruc.fldnames{i},h_btn);
       %
       % add frames
       %
       h_f1 = uicontrol('Units','pixels', ...
          'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
          'ForegroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
          'Position',[TabDLGPosition(1)+btn_1_width+btn_val TabDLGPosition(2)+TabDLGPosition(4)-10 btn_2_width 11], ...
          'Style','frame', ...
          'Tag',['frame1tab' num2str(i)]);
       %
       h_f2 = uicontrol('Units','pixels', ...
          'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
          'ForegroundColor',lightvec, ...
          'Position',[TabDLGPosition(1)+btn_1_width+btn_val-sub_val TabDLGPosition(2)+TabDLGPosition(4) btn_2_width 1], ...
          'Style','frame', ...
          'Visible','on', ...
          'Tag',['frame3tab' num2str(i)]);
      %
      % store the handles in the output structure
      %
      DataStructure = setfield(DataStructure,['frame1tab' num2str(i)],h_f1);
      DataStructure = setfield(DataStructure,['frame3tab' num2str(i)],h_f2);
   else;
      if i==7;
         kids = get(fig,'Children');
         newkids = [];
      end;
      curr_row = ceil(i/6);
      if curr_row>old_curr_row;
         old_curr_row = curr_row;
         btn_val = 0;
         add_height = add_height+20;
      else;
         btn_val = btn_val+btn_mean;
      end;
      %
      h_btn = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'ForegroundColor',[0 0 0], ...
         'Position',[TabDLGPosition(1)+1+btn_val TabDLGPosition(2)+TabDLGPosition(4)-2+add_height btn_2_width 23], ...
         'String',TabInputStruc.strings{i}, ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Visible',TabInputStruc.visible{i}, ...
         'Enable','on', ...
         'Callback',TabInputStruc.callbackstr{i}, ...
         'Tag',TabInputStruc.tags{i});
       %
       %
       temp_btns = [temp_btns h_btn];
       newkids = [newkids;h_btn];
       DataStructure = setfield(DataStructure,TabInputStruc.fldnames{i},h_btn);
   end;
end;
%
% Make sure that any upper row tabs lie underneath a lower row tab
%
if NumTabs>=7;
   set(fig,'Children',[kids;newkids]);
end;
if (IsWinXP==1)&(MatlabNumber>=7)&(isempty(temp_btns)==0);
   %
   % change the CData property of all pushbuttons
   %
   for i=1:size(temp_btns,2);
      uiPos = get(temp_btns(1,i),'Position');
      sizBack = round(uiPos([4 3]));
      uiColor = get(0,'defaultuicontrolbackgroundcolor');
      cdat = shiftdim(repmat(uiColor,[sizBack(2) 1 sizBack(1)]),2);
      %
      height = size(cdat,1);
      width = size(cdat,2);
      %
      % dark lower edge
      %
      cdat(height,:,1) = CurrINI.gui_dark_color(1,1);
      cdat(height,:,2) = CurrINI.gui_dark_color(1,2);
      cdat(height,:,3) = CurrINI.gui_dark_color(1,3);
      %
      % dark right edge
      %
      cdat(:,width,1) = CurrINI.gui_dark_color(1,1);
      cdat(:,width,2) = CurrINI.gui_dark_color(1,2);
      cdat(:,width,3) = CurrINI.gui_dark_color(1,3);
      %
      % light upper edge
      %
      cdat(1,1:width-1,1) = CurrINI.gui_light_color(1,1);
      cdat(1,1:width-1,2) = CurrINI.gui_light_color(1,2);
      cdat(1,1:width-1,3) = CurrINI.gui_light_color(1,3);
      %
      % light left edge
      %
      cdat(1:height-1,1,1) = CurrINI.gui_light_color(1,1);
      cdat(1:height-1,1,2) = CurrINI.gui_light_color(1,2);
      cdat(1:height-1,1,3) = CurrINI.gui_light_color(1,3);
      %
      % shade lower edge
      %
      cdat(height-1,2:width-1,1) = CurrINI.gui_shade_color(1,1);
      cdat(height-1,2:width-1,2) = CurrINI.gui_shade_color(1,2);
      cdat(height-1,2:width-1,3) = CurrINI.gui_shade_color(1,3);
      %
      % shade right edge
      %
      cdat(2:height-1,width-1,1) = CurrINI.gui_shade_color(1,1);
      cdat(2:height-1,width-1,2) = CurrINI.gui_shade_color(1,2);
      cdat(2:height-1,width-1,3) = CurrINI.gui_shade_color(1,3);
      %
      set(temp_btns(1,i),'CData',cdat);
   end;
end;

%
% end of TabDialog.m
%
