function ShowStatus
% ShowStatus: Displays text from axes or uicontrol object on the status bar.
%
% USAGE:
%
%       ShowStatus
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 25, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 3-1-2008:   Made sure that uicontrol and axes has a valid handle and that it is visible.
%
% * 19-5-2008:  Cleaned up the function.
%
% * 20-6-2008:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

fig = findobj('Type','figure','Tag','YADA');
%
if isempty(fig)==0;
   controls = get(fig,'UserData');
   ud = get(controls.status,'UserData');
   %
   co = OverObject('uicontrol');
   if (isempty(co)==0)&(ishandle(co)==1)&(strcmp(lower(get(co,'Visible')),'off')==0);
      if strcmp(lower(get(co,'Style')),'popupmenu')==1;
         pop_str = get(co,'String');
         pop_val = get(co,'Value');
         pop_str = pop_str(pop_val,:);
         set(controls.status,'String',pop_str);
         set(controls.quitmenu,'UserData',pop_str);
         return;
      end;
      co_str = get(co,'TooltipString');
      if isempty(co_str)==1;
         co_str = get(co,'String');
         if isempty(co_str)==0;
            co_str = co_str(1,:);
         end;
      end;
      if (isempty(co_str)==0)&(isequal(controls.status,co)==0);
         set(controls.status,'String',co_str);
         set(controls.quitmenu,'UserData',co_str);
      else;
         set(controls.status,'String',ud.string);
         set(controls.quitmenu,'UserData',ud.string);
      end;
   else;
      set(controls.status,'String',ud.string);
      set(controls.quitmenu,'UserData',ud.string);
   end;
   drawnow;
end;

%
% end of ShowStatus.m
%
