function [action,SelectedSheet] = SheetDlg(SheetStr,FileName,CurrINI)
% SheetDlg: Displays a dialog for selecting a sheet from a spreadsheet file.
%
% USAGE:
%
%       [action,SelectedSheet] = SheetDlg(SheetStr,FileName,CurrINI)
%
% REQUIRED INPUT:  SheetStr (string matrix) with the available sheets.
%
%                  FileName (string vector) with the name of the spreadsheet file.
%
%                  CurrINI (structure) with initialization information.
%
% REQUIRED OUTPUT: action (string vector) that can take on the values "OK" or
%                         "Cancel" depending on which button was pressed. The
%                         default value is "Cancel".
%
%                  SelectedSheet (string vector) with the name of the selected sheet.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 2, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 11-5-2007:  Updated the documentation.
%
% * 9-11-2007:  Updated the documentation.
%
% * 10-1-2008:  Changed the last drawnow call to pause(0.02).
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

scrsz = get(0,'ScreenSize');
%
sheetgui = figure('Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'FileName','SheetDlg.m', ...
   'MenuBar','none', ...
   'Units','pixels', ...
   'Position',[scrsz(3)/2-300 (scrsz(4)-140)/2 600 140], ...
   'Tag','FigSheetDlg', ...
   'Resize','off', ...
   'Visible','off', ...
   'Name',['Select sheet - ' FileName], ...
   'NumberTitle','off', ...
   'WindowStyle','modal', ...
   'CloseRequestFcn','CloseGUI', ...
   'ToolBar','none');
%
if MatlabNumber>=7.0;
   set(sheetgui,'DockControl','off');
end;
%
AxesBox([2 2 598 130],'Sheet Selection',78,[0.5 1],'on',CurrINI);
%
imageaxes = axes('Units','pixels', ...
   'Box','on', ...
   'TickLength',[0 0], ...
   'CameraUpVector',[0 1 0], ...
   'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[14 85 39 39], ...
   'XTickLabelMode','manual', ...
   'YTickLabelMode','manual', ...
   'Tag','AxisLogo', ...
   'XColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'YColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'ZColor',get(0,'defaultuicontrolbackgroundcolor'));
%
bgcolor = get(0,'defaultuicontrolbackgroundcolor');
%
image('CData',MirrorImage(MakeTrans(CurrINI.images.allimages.xlsread_image,[160 160 164],bgcolor)),'Clipping','off','Parent',imageaxes);
%
uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[12 55 88 20], ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Style','text', ...
   'HorizontalAlignment','left', ...
   'String','Select a sheet:', ...
   'Tag','Text');
%
sheets.select = uicontrol('Units','pixels', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[100 60 488 20], ...
   'Value',1, ...
   'String',SheetStr, ...
   'Style','popupmenu', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Tag','SheetsPopup');
%
% Two buttons to select action
%
sheets.ok = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[222.5 20 75 25], ...
   'String','OK', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'UserData','waiting', ...
   'Tag','ButtonOK');
%
sheets.cancel = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[302.5 20 75 25], ...
   'String','Cancel', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'Tag','ButtonCancel');
%
set(sheetgui,'Visible','on');
drawnow;
if MatlabNumber>=7;
   uicontrol(sheets.ok);
end;
waitfor(sheetgui,'waitstatus','inactive');
%
if (isempty(get(sheetgui,'CurrentObject'))==1)|(strcmp(get(get(sheetgui,'CurrentObject'),'Type'),'uicontrol')==0);
   action = 'Cancel';
else;
   action = get(get(sheetgui,'CurrentObject'),'String');
   if isempty(action)==1;
      action = 'Cancel';
   end;
end;
%
SelectedSheet = get(sheets.select,'Value');
%
delete(sheetgui);
drawnow;
pause(0.02);

%
% end of SheetDlg.m
%
