function SetYADAUIControls(maingui,DSGEModel,CurrentModelFile,ImageStructure)
% SetYADAUIControls: Sets properties of YADA's GUI objects based on the DSGEModel structure!
%
% USAGE:
%
%       SetYADAUIControls(controls,DSGEModel,CurrentModelFile,ImageStructure)
%
% REQUIRED INPUTS: maingui (handle) to the YADA main dialog, with userdata giving handles to all the
%                           GUI objects on the YADA main dialog.
%
%                  DSGEModel (structure) with fields whose values should be set as properties of the
%                            GUI objects in controls
%
%                  CurrentModelFile (string vector) with full path and name of the model file.
%
%                  ImageStructure (structure) with fields whose entries are data for images
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 2, 2006.
%                        This version: February 12, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 9-8-2006:   Added the impact of the DSGEModel fields "DAMaximumIterationsValue" and "UseDoublingAlgorithm".
%
% * 14-8-2006:  Added the impact of the fields "ShowProgress" and "ShowProgressClock"
%
% * 28-8-2006:  Took the DSGEModel field "InitializeKalman" into account.
%
% * 30-8-2006:  Added the impact of "OverwriteDraws", "MarginalLikelihoodValue", "SequentialStartIteration",
%               "SequentialStepLength", "SequentialML", "CoverageStart", "CoverageIncrement", and "CoverageEnd".
%
% * 17-11-2006: Added the impact of "DAToleranceValue", "RiccatiMaxIterations", "RiccatiToleranceValue",
%               and "StateCovConst".
%
% * 20-11-2006: Added the effect of "UseOwnInitialState".
%
% * 23-11-2006: Took the "AiM Model File" item on the View menu into account.
%
% * 28-11-2006: The the fields "PosteriorDrawsValue", "SampleBatchValue", "ParallelChainsValue", "BurnInValue",
%               "MHInitialScaleFactor", "MHScaleFactor", and "RandomWeightValue" into account.
%
% * 7-12-2006:  Added the fields "OptMaxIterationsValue", "OptToleranceValue", "MaximizeAlgorithmValue", "StepLengthHessian",
%               "NumberOfGridPoints", "FiniteDifferenceHessian", "CheckOptimum", "CheckTransformedOptimum", "GridWidth",
%               "IRHorizon", "PriorKernel", "KernelDensityValue", and "KernelDensityEstimator".
%
% * 15-12-2006: Made sure that the impact of the value of the fields "PriorKernel" and "PosteriorDensityValue"
%               are taken into account.
%
% * 18-12-2006: Made sure that the controls that depend on the field "RandomNumberValue" are set correctly.
%
% * 21-12-2006: The field "MaxForecastHorizon" is taken into account.
%
% * 22-12-2006: The field "FreqParameterReest" is taken into account.
%
% * 11-1-2007:  The fields "BVARLags", "HarmonicLagDecayValue", "CrossEqTightnessValue", "OverallTightnessValue"
%               "PriorType", and "PriorDiffMeanValue" are taken into account.
%
% * 12-1-2007:  The fields "OmegaPriorType", "WishartType", "VarianceTightnessValue", "WishartDFValue",
%               and "SteadyStatePriorFile" are taken into account.
%
% * 17-1-2007:  The full impact of the field "PriorType" is now taken into account where the necessary controls
%               are now enabled/disabled.
%
% * 22-2-2007:  The fields "NumPredPathsValue" and "PostDrawsUsageValue" are now taken into account.
%
% * 26-2-2007:  The field "RandomizeDraws" is now taken into account.
%
% * 3-4-2007:   The field "PostDrawsPercentValue" is now taken into account.
%
% * 10-4-2007:  The field "InverseHessianEstimator" is now taken into account.
%
% * 16-4-2007:  The field "MaxCorrelationValue" is now taken into account.
%
% * 23-8-2007:  The field "AdjustPredictionPaths" is now taken into account.
%
% * 3-9-2007:   The controls for selecting the estimation sample have been changed from edit controls
%               to popup controls. The function has been updated to take this change into account.
%
% * 25-10-2007: The field "FreqParameterReest" is no longer supported.
%
% * 9-11-2007:  Updated the documentation.
%
% * 17-12-2007: The field "ShockControlMethod" is now taken into account.
%
% * 2-1-2008:   The field "KalmanFirstObservation" is now taken into account properly.
%
% * 23-1-2008:  Made sure that the string property of controls.forecast.maxhorizon is now reset to handle the
%               new behavior of the control.
%
% * 24-1-2008:  The field "KsiUseCondData" is now taken into account.
%
% * 18-2-2008:  The field "ModifiedHessian" is now taken into account.
%
% * 21-2-2008:  Updated the documentation and added the input "CurrentModelFile".
%
% * 19-5-2008:  The fields "BeginYear", "BeginPeriod", "EndYear", and "EndPeriod" are no longer attached to
%               any GUI controls. The field "AIMTolerance" is now also taken into account.
%
% * 23-5-2008:  Updated the documentation.
%
% * 21-7-2008:  Made sure that "PriorKernel" can only be 1 if either "YADAbetarnd" or "betarnd" exists
%               as m-files.
%
% * 19-12-2008: Updated the documentation.
%
% * 29-01-2009: Made sure that "InitializeHessian" is now taken into account.
%
% * 12-02-2009: Made sure that "ParameterCovMatrix" is now taken into account.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if strcmp(DSGEModel.NameOfModel,'')==0;
   if FileExist(CurrentModelFile)==1;
      set(maingui,'Name',['YADA - ' DSGEModel.NameOfModel ' - [' GetFilename(CurrentModelFile) ']']);
   else;
      set(maingui,'Name',['YADA - ' DSGEModel.NameOfModel]);
   end;
else;
   set(maingui,'Name','YADA');
end;
%
controls = get(maingui,'UserData');
set(controls.dsge.aimfile,'String',DSGEModel.AIMFile);
if FileExist(DSGEModel.AIMFile)==1;
   %
   % enable AiM parser controls
   %
   set(controls.runaim,'Enable','on');
   set(controls.runaimmenu,'Enable','on');
   set(controls.aimmodelinfo,'Enable','on');
   %
   % Enable output directory controls
   %
   set(controls.outputdirtext,'Enable','on');
   set(controls.outputdir,'Enable','on');
   set(controls.outputbutton,'Enable','on','CData',ImageStructure.browse);
else;
   set(controls.runaim,'Enable','off');
   set(controls.runaimmenu,'Enable','off');
   set(controls.aimmodelinfo,'Enable','off');
   set(controls.outputdirtext,'Enable','off');
   set(controls.outputdir,'Enable','off');
   set(controls.outputbutton,'Enable','off','CData',ImageStructure.browsedisable);
end;
if FileExist(DSGEModel.AIMDataFile)==1;
   %
   % Enable controls for selecting state variables and state shocks
   %
   set(controls.statevar,'Enable','on');
   set(controls.statevarmenu,'Enable','on');
   set(controls.stateshock,'Enable','on');
   set(controls.stateshockmenu,'Enable','on');
else;
   set(controls.statevar,'Enable','off');
   set(controls.statevarmenu,'Enable','off');
   set(controls.stateshock,'Enable','off');
   set(controls.stateshockmenu,'Enable','off');
end;
set(controls.dsge.datafile,'String',DSGEModel.DataConstructionFile);
if FileExist(DSGEModel.DataConstructionFile)==1;
   %
   % endable control for viewing data construction information
   %
   set(controls.datainfo,'Enable','on');
else;
   set(controls.datainfo,'Enable','off');
end;
set(controls.dsge.initialparameterfile,'String',DSGEModel.InitializeParameterFile);
set(controls.dsge.modelname,'String',DSGEModel.NameOfModel);
set(controls.dsge.measurefile,'String',DSGEModel.MeasurementEquationFile);
set(controls.outputdir,'String',DSGEModel.OutputDirectory);
set(controls.dsge.priorfile,'String',DSGEModel.PriorFile);
set(controls.dsge.priorfilesheet,'String',['Sheet: ' DSGEModel.PriorFileSheet]);
set(controls.dsge.runinitialfirst,'Value',DSGEModel.RunInitializeFirst);
if FileExist(DSGEModel.InitializeParameterFile)==1;
   set(controls.dsge.runinitialfirst,'Enable','on');
else;
   set(controls.dsge.runinitialfirst,'Enable','off');
end;
set(controls.dsge.aimtolerance,'Value',DSGEModel.AIMTolerance-1);
set(controls.dsge.subbeginperiod,'String',DSGEModel.PeriodStrMatrix,'Value',DSGEModel.SubBeginPeriodValue);
set(controls.dsge.subbeginyear,'String',DSGEModel.YearStrMatrix,'Value',DSGEModel.SubBeginYearValue);
set(controls.dsge.subendperiod,'String',DSGEModel.PeriodStrMatrix,'Value',DSGEModel.SubEndPeriodValue);
set(controls.dsge.subendyear,'String',DSGEModel.YearStrMatrix,'Value',DSGEModel.SubEndYearValue);
set(controls.dsge.updateparameterfile,'String',DSGEModel.UpdateParameterFile);
%
set(controls.dsge.doublingalgorithm,'Value',DSGEModel.DAMaximumIterationsValue);
set(controls.dsge.usedoublingalgorithm,'Value',DSGEModel.UseDoublingAlgorithm);
if DSGEModel.UseDoublingAlgorithm==2;
   set(controls.dsge.doublingalgorithmtext,'Enable','on');
   set(controls.dsge.doublingalgorithm,'Enable','on');
   set(controls.dsge.doublingtolerancetext,'Enable','on');
   set(controls.dsge.doublingtolerance,'Enable','on');
   set(controls.dsge.statecovariancetext,'Enable','off');
   set(controls.dsge.statecovariance,'Enable','off');
elseif DSGEModel.UseDoublingAlgorithm==3;
   set(controls.dsge.doublingalgorithmtext,'Enable','off');
   set(controls.dsge.doublingalgorithm,'Enable','off');
   set(controls.dsge.doublingtolerancetext,'Enable','off');
   set(controls.dsge.doublingtolerance,'Enable','off');
   set(controls.dsge.statecovariancetext,'Enable','on');
   set(controls.dsge.statecovariance,'Enable','on');
else;
   set(controls.dsge.doublingalgorithmtext,'Enable','off');
   set(controls.dsge.doublingalgorithm,'Enable','off');
   set(controls.dsge.doublingtolerancetext,'Enable','off');
   set(controls.dsge.doublingtolerance,'Enable','off');
   set(controls.dsge.statecovariancetext,'Enable','off');
   set(controls.dsge.statecovariance,'Enable','off');
end;
set(controls.dsge.progress,'Value',DSGEModel.ShowProgress);
if DSGEModel.ShowProgress==1;
   set(controls.dsge.progressclock,'Enable','on');
else;
   set(controls.dsge.progressclock,'Enable','off');
end;
set(controls.dsge.progressclock,'Value',DSGEModel.ShowProgressClock);
[FirstPeriod,LastPeriod,EstSample] = CreateSubSample(DSGEModel);
if (DSGEModel.InitializeKalman>1)&(DSGEModel.KalmanFirstObservation==1);
   DSGEModel.KalmanFirstObservation = round(((DSGEModel.InitializeKalman-1)/100)*(LastPeriod-FirstPeriod+1))+1;
end;
set(controls.dsge.initializekalman,'String',EstSample,'Value',DSGEModel.KalmanFirstObservation);
set(controls.dsge.overwritedraws,'Value',DSGEModel.OverwriteDraws);
set(controls.dsge.marginallikelihood,'Value',DSGEModel.MarginalLikelihoodValue);
set(controls.dsge.sequentialstart,'Value',DSGEModel.SequentialStartIteration);
set(controls.dsge.sequentialstep,'Value',DSGEModel.SequentialStepLength);
set(controls.dsge.sequentialml,'Value',DSGEModel.SequentialML);
set(controls.dsge.coveragestart,'Value',DSGEModel.CoverageStart);
set(controls.dsge.coverageincrement,'Value',DSGEModel.CoverageIncrement);
set(controls.dsge.coverageend,'Value',DSGEModel.CoverageEnd);
set(controls.dsge.doublingtolerance,'Value',DSGEModel.DAToleranceValue);
set(controls.tools.riccatiiteration,'Value',DSGEModel.RiccatiMaxIterations);
set(controls.tools.riccatitolerance,'Value',DSGEModel.RiccatiToleranceValue);
set(controls.dsge.statecovariance,'Value',DSGEModel.StateCovConst);
set(controls.dsge.useowninitialstate,'Value',DSGEModel.UseOwnInitialState);
set(controls.dsge.allowunitroot,'Value',DSGEModel.AllowUnitRoot);
set(controls.posterior.draws,'Value',DSGEModel.PosteriorDrawsValue);
set(controls.posterior.batch,'Value',DSGEModel.SampleBatchValue);
set(controls.posterior.chains,'Value',DSGEModel.ParallelChainsValue);
set(controls.posterior.burnin,'Value',DSGEModel.BurnInValue);
set(controls.posterior.invhessian,'Value',DSGEModel.InverseHessianEstimator,'String',['Output from optimization routine|Fit quadratic to evaluated log posterior|Finite difference|My estimate ("' GetName(DSGEModel.ParameterCovMatrix) '")']);
set(controls.posterior.maxcorrelation,'Value',DSGEModel.MaxCorrelationValue);
set(controls.posterior.initialscale,'Value',DSGEModel.MHInitialScaleFactor);
set(controls.posterior.scalefactor,'Value',DSGEModel.MHScaleFactor);
set(controls.posterior.randomweight,'Value',DSGEModel.RandomWeightValue);
set(controls.posterior.postdrawsusage,'Value',DSGEModel.PostDrawsUsageValue);
set(controls.posterior.usepostdraws,'Value',DSGEModel.PostDrawsPercentValue);
%
% check if we can draw from the prior distribution
%
if (exist('YADAbetarnd')~=2)|(exist('betarnd')~=2);
   DSGEModel.PriorKernel = 0;
end;
set(controls.optimize.maximumiterations,'Value',DSGEModel.OptMaxIterationsValue);
set(controls.optimize.initcsminwel,'Value',DSGEModel.InitializeHessian);
set(controls.optimize.tolerance,'Value',DSGEModel.OptToleranceValue);
set(controls.optimize.maxroutine,'Value',DSGEModel.MaximizeAlgorithmValue);
set(controls.optimize.steplength,'Value',DSGEModel.StepLengthHessian);
set(controls.optimize.numbergridpoints,'Value',DSGEModel.NumberOfGridPoints);
set(controls.optimize.finitediffhessian,'Value',DSGEModel.FiniteDifferenceHessian);
set(controls.optimize.checkoptimum,'Value',DSGEModel.CheckOptimum);
set(controls.optimize.checktransformed,'Value',DSGEModel.CheckTransformedOptimum);
set(controls.optimize.modifiedhessian,'Value',DSGEModel.ModifiedHessian);
set(controls.optimize.gridwidth,'Value',DSGEModel.GridWidth);
set(controls.tools.irhorizon,'Value',DSGEModel.IRHorizon);
set(controls.graphics.priorkernel,'Value',DSGEModel.PriorKernel);
set(controls.graphics.kerneldensity,'Value',DSGEModel.KernelDensityValue);
set(controls.graphics.posteriorkernel,'Value',DSGEModel.PosteriorDensityValue);
set(controls.tools.randomnumber,'Value',DSGEModel.RandomNumberValue);
set(controls.tools.randomizedraws,'Value',DSGEModel.RandomizeDraws);
set(controls.forecast.maxhorizon,'Value',DSGEModel.MaxForecastHorizon);
ForecastStr = get(controls.forecast.maxhorizon,'UserData');
if strcmp(lower(DSGEModel.DataFrequency),'q')==1;
   set(controls.forecast.maxhorizon,'String',ForecastStr.quarter);
elseif strcmp(lower(DSGEModel.DataFrequency),'m')==1;
   set(controls.forecast.maxhorizon,'String',ForecastStr.month);
else;
   set(controls.forecast.maxhorizon,'String',ForecastStr.annual);
end;
set(controls.forecast.shockcontrol,'Value',DSGEModel.ShockControlMethod);
%set(controls.forecast.freqreest,'Value',DSGEModel.FreqParameterReest);
set(controls.forecast.predpaths,'Value',DSGEModel.NumPredPathsValue);
set(controls.forecast.adjustpredictionpaths,'Value',DSGEModel.AdjustPredictionPaths);
set(controls.forecast.ksiuseconddata,'Value',DSGEModel.KsiUseCondData);
if DSGEModel.CheckOptimum==1;
   set(controls.optimize.gridwidthtext,'Enable','on');
   set(controls.optimize.gridwidth,'Enable','on');
   set(controls.optimize.numbergridpoints,'Enable','on');
   set(controls.optimize.numbergridpointstext,'Enable','on');
   set(controls.optimize.checktransformed,'Enable','on');
   set(controls.optimize.modifiedhessian,'Enable','on');
else;
   set(controls.optimize.gridwidthtext,'Enable','off');
   set(controls.optimize.gridwidth,'Enable','off');
   set(controls.optimize.numbergridpoints,'Enable','off');
   set(controls.optimize.numbergridpointstext,'Enable','off');
   set(controls.optimize.checktransformed,'Enable','off');
   set(controls.optimize.modifiedhessian,'Enable','off');
end;
if DSGEModel.PriorKernel==1;
   set(controls.graphics.kerneldensitytext,'Enable','on');
   set(controls.graphics.kerneldensity,'Enable','on');
else;
   set(controls.graphics.kerneldensitytext,'Enable','off');
   set(controls.graphics.kerneldensity,'Enable','off');
end;
set(controls.bvar.steadystatefile,'String',DSGEModel.SteadyStatePriorFile);
if FileExist(DSGEModel.SteadyStatePriorFile)==1;
   %
   % controls that should be enabled
   %
   
else;
   %
   % controls that should be disabled
   %
   
end;
set(controls.bvar.lag,'Value',DSGEModel.BVARLags);
set(controls.bvar.priorlevelmean,'Value',DSGEModel.PriorLevelMeanValue);
set(controls.bvar.priordiffmean,'Value',DSGEModel.PriorDiffMeanValue);
set(controls.bvar.priortype,'Value',DSGEModel.PriorType);
set(controls.bvar.overalltightness,'Value',DSGEModel.OverallTightnessValue);
set(controls.bvar.crosseqtightness,'Value',DSGEModel.CrossEqTightnessValue);
set(controls.bvar.harmoniclagdecay,'Value',DSGEModel.HarmonicLagDecayValue);
if DSGEModel.PriorType~=3;
   set(controls.bvar.priorlevelmeantext,'Enable','on');
   set(controls.bvar.priorlevelmean,'Enable','on');
   set(controls.bvar.priordiffmeantext,'Enable','on');
   set(controls.bvar.priordiffmean,'Enable','on');
   set(controls.bvar.overalltightnesstext,'Enable','on');
   set(controls.bvar.overalltightness,'Enable','on');
   set(controls.bvar.crosseqtightnesstext,'Enable','on');
   set(controls.bvar.crosseqtightness,'Enable','on');
   set(controls.bvar.harmoniclagdecaytext,'Enable','on');
   set(controls.bvar.harmoniclagdecay,'Enable','on');
else;
   set(controls.bvar.priorlevelmeantext,'Enable','off');
   set(controls.bvar.priorlevelmean,'Enable','off');
   set(controls.bvar.priordiffmeantext,'Enable','off');
   set(controls.bvar.priordiffmean,'Enable','off');
   set(controls.bvar.overalltightnesstext,'Enable','off');
   set(controls.bvar.overalltightness,'Enable','off');
   set(controls.bvar.crosseqtightnesstext,'Enable','off');
   set(controls.bvar.crosseqtightness,'Enable','off');
   set(controls.bvar.harmoniclagdecaytext,'Enable','off');
   set(controls.bvar.harmoniclagdecay,'Enable','off');
end;
set(controls.bvar.omegapriortype,'Value',DSGEModel.OmegaPriorType);
set(controls.bvar.wisharttype,'Value',DSGEModel.WishartType);
set(controls.bvar.variancetightness,'Value',DSGEModel.VarianceTightnessValue);
set(controls.bvar.wishartdf,'Value',DSGEModel.WishartDFValue);
if DSGEModel.OmegaPriorType==1;
   set(controls.bvar.wisharttypetext,'Enable','off');
   set(controls.bvar.wisharttype,'Enable','off');
   set(controls.bvar.variancetightnesstext,'Enable','off');
   set(controls.bvar.variancetightness,'Enable','off');
   set(controls.bvar.wishartdftext,'Enable','off');
   set(controls.bvar.wishartdf,'Enable','off');
else;
   set(controls.bvar.wisharttypetext,'Enable','on');
   set(controls.bvar.wisharttype,'Enable','on');
   set(controls.bvar.wishartdftext,'Enable','on');
   set(controls.bvar.wishartdf,'Enable','on');
   if DSGEModel.WishartType==1;
      set(controls.bvar.variancetightnesstext,'Enable','off');
      set(controls.bvar.variancetightness,'Enable','off');
   else;
      set(controls.bvar.variancetightnesstext,'Enable','on');
      set(controls.bvar.variancetightness,'Enable','on');
   end;
end;

%
% end of SetYADAUIControls.m
%
