function SetLogText(TextStrMat,maingui)
% SetLogText: Writes text to the estimation log window.
%
% USAGE:
%
%       SetLogText(TextStrMat,maingui)
%
% REQUIRED INPUT: TextStrMat (string matrix) with text to add to the log window.
%
% OPTIONAL INPUT: maingui (handle) for the figure where the log window is located.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 8, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 20-5-2008:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% retrieve old log text
%
if nargin==1;
   maingui = findobj('Type','figure','Tag','YADA');
end;
controls = get(maingui,'UserData');
OldLogText = get(controls.estimation_log,'String');
ListTopValue = get(controls.estimation_log,'UserData');
%
% create new log text
%
NewLogText = strvcat(OldLogText,TextStrMat);
%
% Determine if ListboxTop property should be changed
%
if ListTopValue>1;
   ListTopValue = ListTopValue+size(TextStrMat,1);
else;
   FontSizeValue = get(controls.estimation_log,'FontSize');
   PointsPerPixel = 72/get(0,'ScreenPixelsPerInch');
   LogHeight = floor(382*PointsPerPixel);
   LogTextHeight = FontSizeValue*size(NewLogText,1);
   if LogTextHeight>LogHeight;
      ListTopValue = ListTopValue+size(TextStrMat,1);
   end;
end;
%
% Insert new properties into log control
%
set(controls.estimation_log,'String',NewLogText,'ListboxTop',ListTopValue,'UserData',ListTopValue);
drawnow;
if get(controls.estimation_log,'ListboxTop')~=ListTopValue;
   set(controls.estimation_log,'ListboxTop',ListTopValue,'UserData',ListTopValue);
   drawnow;
end;

%
% end of SetLogText.m
%
