function [action,SelectedOption] = SelectionDlg(SelectionOptions,DefaultOption,SelectionStr,BoxStr,WindowNameStr,CommentsStrMat,CommentNameStr,CurrINI)
% SelectionDlg: generic dialog for selecting a row of a string matrix.
%
% USAGE:
%
%       [action,SelectedOption] = SelectionDlg(SelectionOptions,DefaultOption,SelectionStr,BoxStr,WindowNameStr,CommentsStrMat,CommentNameStr,CurrINI)
%
% REQUIRED INPUT:  SelectionOptions (string matrix) displaying the possible options to select between. The
%                                   string matrix is displayed in a popup control.
%
%                  DefaultOption (integer) with the value to display in the string matrix.
%
%                  SelectionStr (string vector), with the text to display above the selection popup control.
%
%                  BoxStr (string vector), with the text to display in the axes box surrounding the controls.
%
%                  WindowNameStr (string vector), with the text to display in the window name.
%
%                  CommentsStrMat (string matrix) which if non-empty makes it possible to display comments
%                                   for the current selection.
%
%                  CommentNameStr (string vector) with the base for the figure name for the About dialog
%                                   that shows comments.
%
%                  CurrINI (structure), with initialization information.
%
% REQUIRED OUTPUT: action (string vector), taking on the possible values "OK" and "Cancel", depending on the
%                                   action chosen by the user.
%
%                  SelectedOption (integer) with the value selected from the string matrix in "SelectionOptions".
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: November 10, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 23-11-2006: Added a check if the current object is empty after waitfor function.
%
% * 11-5-2007:  Updated the documentation.
%
% * 9-11-2007:  Updated the documentation.
%
% * 10-1-2008:  Changed the last drawnow call to pause(0.02).
%
% * 1-2-2008:   Added the inputs "CommentsStrMat" and "CommentNameStr".
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

scrsz = get(0,'ScreenSize');
%
SelectionGUI = figure('Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'FileName','SelectionDlg.m', ...
   'MenuBar','none', ...
   'Units','pixels', ...
   'Position',[scrsz(3)/2-250 (scrsz(4)-120)/2 500 120], ...
   'Tag','FigSheetDlg', ...
   'Resize','off', ...
   'Visible','off', ...
   'Name',WindowNameStr, ...
   'NumberTitle','off', ...
   'WindowStyle','modal', ...
   'CloseRequestFcn','CloseGUI', ...
   'ToolBar','none');
%
if MatlabNumber>=7.0;
   set(SelectionGUI,'DockControl','off');
end;
%
AxesBox([2 2 498 110],BoxStr,78,[0.5 1],'on',CurrINI);
%
uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[14 80 472 20], ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Style','text', ...
   'HorizontalAlignment','left', ...
   'String',SelectionStr, ...
   'Tag','Text');
%
controls.select = uicontrol('Units','pixels', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[14 60 472 20], ...
   'Value',DefaultOption, ...
   'String',SelectionOptions, ...
   'Style','popupmenu', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Tag','SheetsPopup');
%
% create a button for displaying
%
if isempty(CommentsStrMat)==0;
   CommentUD.CommentsStrMat = CommentsStrMat;
   CommentUD.control = controls.select;
   if isempty(StringTrim(CommentNameStr))==0;
      CommentUD.NameStr = StringTrim(CommentNameStr);
   else;
      CommentUD.NameStr = 'Comment';
   end;
   CommentUD.CurrINI =CurrINI;
   controls.comment = uicontrol('Units','pixels', ...
      'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
      'Position',[14 20 125 25], ...
      'String','View Comment', ...
      'FontSize',CurrINI.gui_fontsize, ...
      'FontName',CurrINI.gui_fontname, ...
      'FontWeight',CurrINI.gui_fontweight, ...
      'FontAngle',CurrINI.gui_fontangle, ...
      'Enable','on', ...
      'Callback','DisplayComment', ...
      'UserData',CommentUD, ...
      'Tag','ButtonComment');
end;
%
% Two buttons to select action
%
controls.ok = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[172.5 20 75 25], ...
   'String','OK', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'UserData','waiting', ...
   'Tag','ButtonOK');
%
controls.cancel = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[252.5 20 75 25], ...
   'String','Cancel', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'Tag','ButtonCancel');
%
set(SelectionGUI,'Visible','on');
drawnow;
if MatlabNumber>=7;
   uicontrol(controls.ok);
end;
waitfor(SelectionGUI,'waitstatus','inactive');
%
if (isempty(get(SelectionGUI,'CurrentObject'))==1)|(strcmp(get(get(SelectionGUI,'CurrentObject'),'Type'),'uicontrol')==0);
   action = 'Cancel';
else;
   action = get(get(SelectionGUI,'CurrentObject'),'String');
   if isempty(action)==1;
      action = 'Cancel';
   end;
end;
%
SelectedOption = get(controls.select,'Value');
%
delete(SelectionGUI);
drawnow;
pause(0.02);

%
% end of SelectionDlg.m
%
