function [action,NewBaseName,NewBaseNameComment] = SaveDataDLG(selector,BaseName,BaseNameComment,CurrINI)
% SaveDataDLG: Diaglog for selecting a base name a comments for some data to be stored on disk.
%
% USAGE:
%
%       [action,NewBaseName,NewBaseNameComment] = SaveDataDLG(selector,BaseName,BaseNameComment,CurrINI)
%
% REQUIRED INPUT:  selector (string vector) that defines the sub-function to run.
%
% OPTIONAL INPUT:  BaseName (string vector) with the original base name for the data file. Required if
%                           selector is "init".
%
%                  BaseNameComment (string vector) with the original comments to store in the data file.
%                           Required if selector is "init".
%
%                  CurrINI (structure) with initialization information.
%
% OPTIONAL OUTPUT: action (string vector) that takes on the values "OK" or "Cancel". Required if selector
%                           is "init".
%
%                  NewBaseName (string vector) with the new base name for the data file. Required if
%                           selector is "init".
%
%                  NewBaseNameComment (string vector) with the new comments to store in the data file.
%                           Required if selector is "init".
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: October 8, 2007.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 30-10-2007: Updated the documentation.
%
% * 10-1-2008:  Changed the last drawnow call to pause(0.02).
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if strcmp(selector,'init')==1;
   scrsz = get(0,'ScreenSize');
   width = 600;
   height = 300;
else;
   SaveDataGUI = get(0,'CurrentFigure');
   SaveDataControls = get(SaveDataGUI,'UserData');
   CurrINI = get(SaveDataControls.textcommentaxes,'UserData');
end;
%
switch selector;
   case 'init';
      SaveDataGUI = figure('Color',get(0,'defaultuicontrolbackgroundcolor'), ...
         'FileName','SaveDataDLG.m', ...
         'MenuBar','none', ...
         'Units','pixels', ...
         'Position',[(scrsz(3)-width)/2 (scrsz(4)-height)/2 width height], ...
         'Tag','FigEditDLG', ...
         'Resize','off', ...
         'Name','Set Base Name And Comment', ...
         'Visible','off', ...
         'NumberTitle','off', ...
         'WindowStyle','modal', ...
         'CloseRequestFcn','SaveDataDLG close', ...
         'ToolBar','none');
      %
      if MatlabNumber>=7.0;
         set(SaveDataGUI,'DockControl','off');
      end;
      %
      AxesBox([2 2 width-2 height-10],'Select Base Name',100,[0.5 1],'on',CurrINI);
      %
      % Base name controls
      %
      uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[14 height-47 200 20], ...
         'String','Base name for the data:', ...
         'Style','text', ...
         'HorizontalAlignment','left', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Enable','on', ...
         'Tag','TextHeader');
      %
      SaveDataControls.edit = uicontrol('Units','pixels', ...
         'BackgroundColor',[1 1 1], ...
         'Position',[150 height-42 width-164 20], ...
         'String',BaseName, ...
         'Style','edit', ...
         'HorizontalAlignment','left', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'CallBack','SaveDataDLG checkedit', ...
         'UserData',BaseName, ...
         'Enable','on', ...
         'Tag','EditEdit');
      %
      % comment controls
      %
      uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[14 height-67 200 20], ...
         'String','Comments for the data:', ...
         'Style','text', ...
         'HorizontalAlignment','left', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Enable','on', ...
         'Tag','TextCommentHeader');
      %
      % create a temporary text uicontrol
      %
      TmpControl = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[14 53 width-28 height-120], ...
         'String',BaseNameComment, ...
         'Style','text', ...
         'HorizontalAlignment','left', ...
         'FontSize',CurrINI.text_fontsize, ...
         'FontName',CurrINI.text_fontname, ...
         'Visible','off', ...
         'Enable','on', ...
         'Tag','TextHeader');
      %
      % run the text wrap function
      %
      MultiLineBaseNameComment = textwrap(TmpControl,cellstr(BaseNameComment));
      BaseNameComment = char(MultiLineBaseNameComment);
      %
      % make sure the control is deleted
      %
      delete(TmpControl);
      %
      % Axes for text controls
      %
      SaveDataControls.textcommentaxes = axes('Units','pixels', ...
         'Box','on', ...
         'TickLength',[0 0], ...
         'CameraUpVector',[0 1 0], ...
         'Color',[1 1 1], ...
         'Position',[14 53 width-28 height-120], ...
         'XTickLabelMode','manual', ...
         'YTickLabelMode','manual', ...
         'Tag','TextCommentAxes', ...
         'UserData',CurrINI, ...
         'XColor',[0 0 0], ...
         'YColor',[0 0 0], ...
         'ZColor',[0 0 0]);
      %
      % text control
      %
      SaveDataControls.textcomment = text('Parent',SaveDataControls.textcommentaxes, ...
         'Position',[0.01 0.99], ...
         'String',BaseNameComment, ...
         'FontSize',CurrINI.text_fontsize, ...
         'FontName',CurrINI.text_fontname, ...
         'HorizontalAlignment','left', ...
         'Clipping','on', ...
         'VerticalAlignment','top', ...
         'Interpreter','none', ...
         'Color',[0 0 0], ...
         'ButtonDownFcn','SaveDataDLG checktext', ...
         'UserData',BaseNameComment, ...
         'Tag','TextComment');
      %
      % Two buttons to select action
      %
      SaveDataControls.ok = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[width-169 14 75 25], ...
         'String','OK', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Enable','on', ...
         'Callback','SaveDataDLG close', ...
         'UserData','waiting', ...
         'Tag','ButtonOK');
      %
      SaveDataControls.cancel = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[width-89 14 75 25], ...
         'String','Cancel', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Enable','on', ...
         'UserData','Cancel', ...
         'Callback','SaveDataDLG close', ...
         'Tag','ButtonCancel');
      %
      set(SaveDataGUI,'UserData',SaveDataControls,'HandleVisibility','callback');
   case 'checktext'
      set(SaveDataControls.textcomment,'Editing','on');
      %
      % disable controls
      %
      set(SaveDataControls.ok,'Enable','off');
      set(SaveDataControls.cancel,'Enable','off');
      set(SaveDataControls.edit,'Enable','off');
      set(SaveDataGUI,'CloseRequestFcn','');
      %
      waitfor(SaveDataControls.textcomment,'editing','off');
      %
      % enable controls
      %
      set(SaveDataControls.ok,'Enable','on');
      set(SaveDataControls.cancel,'Enable','on');
      set(SaveDataControls.edit,'Enable','on');
      set(SaveDataGUI,'CloseRequestFcn','SaveDataDLG close');
      %
      %
      NewTextStr = get(SaveDataControls.textcomment,'String');
      FixedTextStr = '';
      for i=1:size(NewTextStr);
         FixedTextStr = [FixedTextStr ' ' StringTrim(NewTextStr(i,:))];
      end;
      FixedTextStr = StringTrim(FixedTextStr);
      if isempty(FixedTextStr)==1;
         set(SaveDataControls.textcomment,'String',get(SaveDataControls.textcomment,'UserData'));
      else;
         %
         % now we wish to wrap the text.
         %
         TmpControl = uicontrol('Parent',SaveDataGUI, ...
         'Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',get(SaveDataControls.textcommentaxes,'Position'), ...
         'String',FixedTextStr, ...
         'Style','text', ...
         'HorizontalAlignment','left', ...
         'FontSize',CurrINI.text_fontsize, ...
         'FontName',CurrINI.text_fontname, ...
         'Visible','off', ...
         'Enable','on', ...
         'Tag','TextHeader');
         %
         % run the text wrap function
         %
         MultiLineFixedTextStr = textwrap(TmpControl,cellstr(FixedTextStr));
         FixedTextStr = char(MultiLineFixedTextStr);
         %
         % make sure the control is deleted
         %
         delete(TmpControl);
         %
         set(SaveDataControls.textcomment,'String',FixedTextStr);
      end;
   case 'checkedit'
      %
      % check to make sure that we have some reasonable text
      %
      NewBaseName = RemoveIllegalChars(StringTrim(get(SaveDataControls.edit,'String')));
      %
      % remove illegal characters
      %
      if isempty(NewBaseName)==1;
         set(SaveDataControls.edit,'String',get(SaveDataControls.edit,'UserData'));
      else;
         set(SaveDataControls.edit,'String',NewBaseName);
      end;
   case 'close'
      if gco==SaveDataControls.ok;
         set(SaveDataControls.cancel,'UserData','OK');
      end;
      set(SaveDataGUI,'UserData',SaveDataControls);
      set(SaveDataControls.ok,'UserData','done');
end;
%
%
%
if strcmp(selector,'init')==1;
   set(SaveDataGUI,'Visible','on');
   drawnow;
   %
   waitfor(SaveDataControls.ok,'UserData','done');
   action = get(SaveDataControls.cancel,'UserData');
   if strcmp(lower(action),'ok')==1;
      NewBaseName = get(SaveDataControls.edit,'String');
      NewBaseNameCommentTxt = get(SaveDataControls.textcomment,'String');
      %
      % make sure we have a string vector
      %
      NewBaseNameComment = '';
      for i=1:size(NewBaseNameCommentTxt,1);
         NewBaseNameComment = [NewBaseNameComment ' ' StringTrim(NewBaseNameCommentTxt(i,:))];
      end;
      NewBaseNameComment = StringTrim(NewBaseNameComment);
   else;
      NewBaseName = BaseName;
      NewBaseNameComment = BaseNameComment;
   end;
   %
   % delete the GUI
   %
   delete(SaveDataGUI);
   drawnow;
   pause(0.02);
end;

%
% end of SaveDataDLG.m
%
