function ImageStructure = ReadImages
% ReadImages: Reads image information from the yada-images file and makes the
%             necessary transformations for applying these as CData in toolbar
%             buttons and pushbutton.
%
% USAGE:
%
%       ImageStructure = ReadImages
%
% REQUIRED OUTPUT: ImageStructure (structure). The fields are given by button names such as
%                                 open, close, etc.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 21, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 25-7-2006:  Changed the background color of images for UI controls from white to a suitable color close
%               to white!
%
% * 2-8-2006:   Added the "clear", "statevar", and "stateshock" fields.
%
% * 3-8-2006:   Added the "postmode" field.
%
% * 8-8-2006:   Added the "cleanup" field.
%
% * 14-8-2006:  Added the "reload" field.
%
% * 21-8-2006:  Added the "viewgraphics" field.
%
% * 29-8-2006:  Added the fields "print", "new", "zoomin", "zoomout", "arrow", "line", "text", and "rotate3d".
%
% * 5-12-2006:  Added the field "shockgroups".
%
% * 11-9-2007:  Added the fields "down" and "up".
%
% * 1-10-2007:  Added the fields "undo" and "undodisable".
%
% * 2-10-2007:  Fixed a bug where the field "undo" was incorrectly called "updo".
%
% * 7-11-2007:  Added the field "econshocks".
%
% * 9-11-2007:  Added the field "editplot" and "exportdata".
%
% * 16-11-2007: The "undo" image is now only used on toolbars. The undodisable image has
%               been removed.
%
% * 6-3-2008:   Added the "help" image.
%
% * 28-3-2008:  Added the "summary" image.
%
% * 31-3-2008:  Added the "txtprint" image.
%
% * 24-4-2008:  The icon "econshocks" is now called "runscenario".
%
% * 21-5-2008:  Wrote the full path to the "yada-images.mat" file for the load function.
%
% * 23-5-2008:  Updated the documentation.
%
% * 22-7-2008:  Added the "decomp" image.
%
% * 15-8-2008:  Added the "plotshocks" image.
%
% * 21-11-2008: Added the "YADAlicense" image.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% load the data.
%
mycons = load([pwd '\gui\yada-images.mat']);
%
% Swapping colors
%
BGColor = [NaN NaN NaN];
if (IsWinXP==1)&(MatlabNumber>=7);
   %
   % we assume that under Windows XP with matlab 7 or later, the
   % color for buttons is white
   %
   BGColorUIControl = (1/255)*[244 244 240];
else;
   BGColorUIControl = get(0,'defaultuicontrolbackgroundcolor');
end;
%
% setting up the structure with CData for toolbar buttons
%
ImageStructure.open = MakeTrans(mycons.open_image,[160 160 164],BGColor);
ImageStructure.save = MakeTrans(mycons.save_image,[160 160 164],BGColor);
ImageStructure.runaim = MakeTrans(mycons.runaim_image,[160 160 164],BGColor);
ImageStructure.simulate = MakeTrans(mycons.simulate_image,[160 160 164],BGColor);
ImageStructure.about = MakeTrans(mycons.about_image,[160 160 164],BGColor);
ImageStructure.YADAlicense = MakeTrans(mycons.YADAlicense_image,[160 160 164],BGColor);
ImageStructure.clear = MakeTrans(mycons.clear_image,[160 160 164],BGColor);
ImageStructure.close = MakeTrans(mycons.close_image,[160 160 164],BGColor);
ImageStructure.statevar = MakeTrans(mycons.statevar_image,[160 160 164],BGColor);
ImageStructure.stateshock = MakeTrans(mycons.stateshock_image,[160 160 164],BGColor);
ImageStructure.postmode = MakeTrans(mycons.postmode_image,[160 160 164],BGColor);
ImageStructure.reload = MakeTrans(mycons.reload_image,[160 160 164],BGColor);
ImageStructure.viewgraphics = MakeTrans(mycons.viewgraphics_image,[160 160 164],BGColor);
ImageStructure.print = MakeTrans(mycons.print_image,[160 160 164],BGColor);
ImageStructure.new = MakeTrans(mycons.new_image,[160 160 164],BGColor);
ImageStructure.zoomin = MakeTrans(mycons.zoomin_image,[160 160 164],BGColor);
ImageStructure.zoomout = MakeTrans(mycons.zoomout_image,[160 160 164],BGColor);
ImageStructure.arrow = MakeTrans(mycons.arrow_image,[160 160 164],BGColor);
ImageStructure.line = MakeTrans(mycons.line_image,[160 160 164],BGColor);
ImageStructure.text = MakeTrans(mycons.text_image,[160 160 164],BGColor);
ImageStructure.rotate3d = MakeTrans(mycons.rotate3d_image,[160 160 164],BGColor);
ImageStructure.shockgroups = MakeTrans(mycons.shockgroups_image,[160 160 164],BGColor);
ImageStructure.runscenario = MakeTrans(mycons.runscenario_image,[160 160 164],BGColor);
ImageStructure.editplot = MakeTrans(mycons.editplot_image,[160 160 164],BGColor);
ImageStructure.exportdata = MakeTrans(mycons.exportdata_image,[160 160 164],BGColor);
ImageStructure.undo = MakeTrans(mycons.undo_image,[160 160 164],BGColor);
ImageStructure.help = MakeTrans(mycons.help_image,[160 160 164],BGColor);
ImageStructure.summary = MakeTrans(mycons.summary_image,[160 160 164],BGColor);
ImageStructure.txtprint = MakeTrans(mycons.txtprint_image,[160 160 164],BGColor);
ImageStructure.decomp = MakeTrans(mycons.decomp_image,[160 160 164],BGColor);
ImageStructure.plotshocks = MakeTrans(mycons.plotshocks_image,[160 160 164],BGColor);
%
% setting up the structure with CData for push-buttons
%
ImageStructure.browse = MakeTrans(mycons.browse_image,[160 160 164],BGColorUIControl);
ImageStructure.browsedisable = MakeTrans(mycons.browsedisable_image,[160 160 164],BGColorUIControl);
ImageStructure.rename = MakeTrans(mycons.rename_image,[160 160 164],BGColorUIControl);
ImageStructure.cleanup = MakeTrans(mycons.cleanup_image,[160 160 164],BGColorUIControl);
ImageStructure.down = MakeTrans(mycons.down_image,[160 160 164],BGColorUIControl);
ImageStructure.up = MakeTrans(mycons.up_image,[160 160 164],BGColorUIControl);
%
% Store all images in orignal format
%
ImageStructure.allimages = mycons;

%
% end of ReadImages.m
%
