%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                %
%          MatLab function for estimating cointegration          %
%          relations under linear restrictions                   %
%                                                                %
%          Function: ProgressDLG                                 %
%                                                                %
%          Input:                                                %
%          		          x: real number between 0 and 1           %
%                         and without handle real + value of     %
%                         convergence criterion                  %
%                       whichbar: structure with 8 arguments     %
%                         whichbar.title: title bar              %
%                         whichbar.name: Figure name             %
%                         whichbar.edgecolor: Edge Color         %
%                         whichbar.facecolor: Face Color         %
%                           for patchfunction, e.g. RGB triple   %
%                         whichbar.label: label string           %
%                         whichbar.stop: 1 shows stop button     %
%                           0 no stop button                     %
%                         whichbar.clock: 1 displays clock       %
%                           0 no clock                           %
%                         whichbar.CurrINI: structure with       %
%                           initialization information           %
%                       or                                       %
%                         nothing                                %
%                                                                %
%          Output:                                               %
%          	          	fout: figure handle                      %
%                                                                %
%          Comment: Rewrite of waitbar function in MatLab        %
%                                                                %
%          This version:        August 18, 2006                  %
%          Written by: 	        Anders Warne                     %
%                               Copyright (c) 2001-2006          %
%                                                                %
%          Other info:                                           %
%                                                                %
%          Clay M. Thompson 11-9-92                              %
%          Copyright (c) 1984-98 by The MathWorks, Inc.          %
%          $Revision: 1.14 $  $Date: 1998/09/01 21:49:34 $       %
%                                                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function fout = ProgressDLG(x,whichbar)

if size(x,2)==2;
   y2 = x(1,2);
elseif size(x,2)==3;
   y2 = x(1,2:3);
end;

if nargin>=2 & isstruct(whichbar)
   type_var=2; %we are initializing
   if isfield(whichbar,'title')==0;
      whichbar.title = 'No title';
   end;
   if isfield(whichbar,'edgecolor')==0;
      whichbar.edgecolor = [0 0 0];
   end;
   if isfield(whichbar,'facecolor')==0;
      whichbar.facecolor = (1/255)*[166 210 255];
   end;
   if isfield(whichbar,'startfacecolor')==0;
      whichbar.startfacecolor = (1/255)*[0 36 104];
   end;
   if isfield(whichbar,'stop')==0;
      whichbar.stop = 0;
   end;
   if isfield(whichbar,'clock')==0;
      whichbar.clock = 0;
   end;
   CurrINI = whichbar.CurrINI;
   name=whichbar;
   my_screenSize = get(0,'ScreenSize');
elseif nargin>=2 & isnumeric(whichbar)
   type_var=1; %we are updating, given a handle
   f=whichbar;
elseif nargin==1
   my_screenSize = get(0,'ScreenSize');
   f = findobj(allchild(0),'flat','Tag','TMWProgressDLG');
   
   if isempty(f)
      type_var=2;
      name='Progress dialog';
   else
      type_var=1;
      f=f(1);
   end   
elseif nargin==2
   error('Two-argument syntax requires ProgressDLG(X,''title'') or ProgressDLG(X,H)')
end

x = max(0,min(100*x,100));

switch type_var
case 1,  % ProgressDLG(x)    update
   x2 = x(1,2);
   x = x(1,1);
   p = findobj(f,'Type','patch','Tag','progress');
   %
   face_color = get(p,'FaceColor');
   edge_color = get(p,'EdgeColor');
   mytitle = get(f,'Name');
   myx = num2str(x,'%0.1f');
   my_clock = findobj(f,'Tag','Clock');
   if (isempty(my_clock)==0)&(ishandle(my_clock)==1);
      set(my_clock,'String',SecondsToHoursStr(toc));
   end;

   f1 = findobj(f,'Type','uicontrol','Tag','ProgressCancel');
   ud = get(f1,'UserData');
   myxlabel = ud.myxlabel;
   oldx = ud.oldx;
   name = ud.name;
   mytitle = strrep(mytitle,[' - ' oldx '%'],'');
   mytitle = [mytitle ' - ' myx '%'];
   set(f,'Name',mytitle);
   if isempty(f) | isempty(p);
      error('Couldn''t find ProgressDLG handles.'); 
   end
   xpatch = get(p,'XData');
   %replace 0 with xpatch(2)
   xpatch = [xpatch(2) x x xpatch(2)];
   xpatch = [0 x x 0];
   b_map = get(f,'Colormap');
   p_color = b_map(floor((63*x)/100)+1,:);
   set(p,'XData',xpatch','FaceColor',p_color,'EdgeColor',edge_color);
%   set(p,'XData',xpatch','FaceColor',face_color,'EdgeColor',edge_color);
   oldx = myx;
   if isfield(name,'label')==0;
      mylabstr = ['Convergence criterion: ' num2str(y2)];
   else;
      if size(y2,2)==1;
         if abs(y2-round(y2))==0;
            mylabstr = [name.label ' ' num2str(y2)];
         else;
            mylabstr = [name.label ' ' num2str(y2,'%0.4f')];
         end;
      elseif size(y2,2)==2;
         mylabstr = [name.label ' (' num2str(y2(1),'%0.4f') ',' num2str(y2(2),'%0.4f') ')'];
      end;
   end;

   set(myxlabel,'String',mylabstr);
   drawnow;
case 3,
   h = get(0,'CurrentFigure');
   f1 = findobj('Type','uicontrol','Tag','ProgressCancel');
   ud = get(f1,'UserData');
   oldx = ud.oldx;
   name = ud.name;
   myxlabel = ud.myxlabel;
   set(h,'UserData','cancel');
case 2,  % ProgressDLG(x,name)  initialize

   oldx = '0';
   oldRootUnits = get(0,'Units');

   set(0, 'Units', 'points');
   screenSize = get(0,'ScreenSize');
   
   axFontSize=get(0,'FactoryAxesFontSize');
   
   pointsPerPixel = 72/get(0,'ScreenPixelsPerInch');
      
   width = 500 * pointsPerPixel;
   height = 140 * pointsPerPixel;
   pos = [screenSize(3)/2-width/2 screenSize(4)/2-height/2 width height];
   
   if isfield(name,'name')==1;
      fig_name = name.name;
      if ischar(fig_name)==1;
         fig_name = StringTrim(fig_name(1,:));
         if strcmp(fig_name,'')==1;
            fig_name = 'Wait';
         end;
      else;
         fig_name = 'Wait';
      end;
   else;
      fig_name = 'Wait';
   end;

   f = figure(...
           'Units', 'points', ...
           'Position', pos, ...
           'Resize','off', ...
           'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
           'CreateFcn','', ...
           'CloseRequestFcn','CloseProgressDLG', ...
           'NumberTitle','off', ...
           'IntegerHandle','off', ...
           'MenuBar', 'none', ...
           'WindowStyle','modal', ...
           'Tag','TMWProgressDLG',...
           'DoubleBuffer','on', ...
           'Name',fig_name, ...
           'UserData','working',...
           'Visible','off');
   colormap([]);
   %
   % now we create a colormap
   %
   barcolor2 = name.facecolor;
   if isfield(name,'startfacecolor')==1;
      barcolor1 = name.startfacecolor;
   else;
      barcolor1 = (1/255)*[0 36 104];
   end;
   b_map = zeros(64,3);
   for i=1:64;
      b_map(i,1:3) = barcolor1 + ((i-1)/63)*(barcolor2-barcolor1);
   end;
   set(f,'Colormap',b_map);

   if MatlabNumber>=7.0;
      set(f,'DockControl','off');
   end;

   %
   % Outer axis
   %

   AxesBox([2 2 (width/pointsPerPixel)-2 (height/pointsPerPixel)-10],'Progress',45,[0.5 1],'on',CurrINI);

   if name.stop==1;
      addthis = 42.5;
   else;
      addthis = 0;
   end;

   if name.clock==1;
      f3 = uicontrol('Units','pixels', ...
            'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
            'Units','Points',...
            'Position',[14 14 50 10], ...
            'String','00:00:00.00', ...
            'Style','text', ...
            'HorizontalAlignment','left', ...
            'FontSize',CurrINI.gui_fontsize, ...
            'FontName',CurrINI.gui_fontname, ...
            'FontWeight',CurrINI.gui_fontweight, ...
            'FontAngle',CurrINI.gui_fontangle, ...
            'Enable','on', ...
            'Tag','Clock');
      tic;

   end;

   axNorm=[.05 .15 .9 .3];
   axPos=axNorm.*[pos(3:4),pos(3:4)];
   axPos(2) = 55;
   
   h = axes('XLim',[0 100],...
      'YLim',[0 1],...
      'Box','on', ...
      'Units','Points',...
      'FontSize', axFontSize,...
      'Position',axPos,...
      'XTickMode','manual',...
      'YTickMode','manual',...
      'Color',name.bgcolor, ...
      'XColor',name.edgecolor, ...
      'YColor',name.edgecolor, ...
      'XTick',[],...
      'YTick',[],...
      'XTickLabelMode','manual',...
      'XTickLabel',[],...
      'YTickLabelMode','manual',...
      'YTickLabel',[]);

   if isfield(name,'label')==0;
      mylabstr = ['Convergence criterion: 1'];
   else;
      mylabstr = [name.label ' 0'];
   end;

   myxlabel = xlabel(mylabstr);

%   if my_screenSize(3)<=1280;
      set(myxlabel,'FontSize',CurrINI.gui_fontsize,'FontName',CurrINI.gui_fontname,'FontWeight',CurrINI.gui_fontweight,'FontAngle',CurrINI.gui_fontangle,'Color',[0 0 0]);
%   else;
%      set(myxlabel,'FontSize',7);
%   end;
%   set(myxlabel,'HorizontalAlignment','left');
   set(myxlabel,'HorizontalAlignment','center');
   set(myxlabel,'Units','pixels');
   check = get(myxlabel,'Position');
   tHandle=title(name.title);
   tHandle=get(h,'title');
   oldTitleUnits=get(tHandle,'Units');
   newpos = get(tHandle,'Position');
   set(tHandle,...
      'Units',      'points',...
      'String',     name.title);

%   if my_screenSize(3)<=1280;
      set(tHandle,'FontName',CurrINI.gui_fontname, ...
          'FontSize',CurrINI.gui_fontsize+2, ...
          'FontWeight',CurrINI.gui_fontweight, ...
          'FontAngle',CurrINI.gui_fontangle);
%   else;
%      set(tHandle,'FontSize',8);
%   end;

   tExtent=get(tHandle,'Extent');
   set(tHandle,'Units',oldTitleUnits);

   check_char = findstr(name.title,'_');

   if isempty(check_char)==0;
      old_u = get(tHandle,'Units');
      set(tHandle,'Units','pixels');
      t_pos = get(tHandle,'Position');
      t_pos(2) = t_pos(2)-5;
      set(tHandle,'Position',t_pos);
      set(tHandle,'Units',old_u);
   end;
   
   xpatch = [0 x x 0];
   ypatch = [0 0 1 1];

   %
   % Making patch height smaller
   %

   oldu = get(h,'Units');
   set(h,'Units','pixels');
   awpos = get(h,'Position');
%   set(h,'Position',[awpos(1,1:3) 18]);
   set(h,'Position',[awpos(1,1:3) 16]);
   set(h,'Units',oldu);

   p = patch('XData',xpatch,'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',name.facecolor,'EraseMode','normal','LineWidth',1,'Tag','progress');
   %
   p1 = patch('XData',[9.5 10.5 10.5 9.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[9.75 10.25 10.25 9.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[19.5 20.5 20.5 19.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[19.75 20.25 20.25 19.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[29.5 30.5 30.5 29.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[29.8 30.25 30.25 29.8],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[39.5 40.5 40.5 39.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[39.75 40.25 40.25 39.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[49.5 50.5 50.5 49.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[49.75 50.25 50.25 49.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[59.5 60.5 60.5 59.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[59.75 60.25 60.25 59.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[69.5 70.5 70.5 69.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[69.75 70.2 70.2 69.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[79.5 80.5 80.5 79.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[79.75 80.25 80.25 79.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');
   %
   p1 = patch('XData',[89.5 90.5 90.5 89.5],'YData',ypatch,'EdgeColor',name.edgecolor,'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','edge');
   p2 = patch('XData',[89.75 90.25 90.25 89.75],'YData',ypatch,'EdgeColor',get(0,'defaultuicontrolbackgroundcolor'),'FaceColor',get(0,'defaultuicontrolbackgroundcolor'),'EraseMode','none','LineWidth',1,'Tag','face');

   if name.stop==1;
      f2 = uicontrol('Units','pixels', ...
            'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
            'Units','Points',...
            'Position',[width/2-82.5 14 80 20], ...
            'String','Done', ...
            'FontSize',CurrINI.gui_fontsize, ...
            'FontName',CurrINI.gui_fontname, ...
            'FontWeight',CurrINI.gui_fontweight, ...
            'FontAngle',CurrINI.gui_fontangle, ...
            'CallBack','StopProgressDLG', ...
            'Enable','on', ...
            'Tag','Stop');
   end;

   f1 = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Units','Points',...
         'Position',[width/2-40+addthis 14 80 20], ...
         'String','Cancel', ...
         'Tag','ProgressCancel', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'CallBack','CancelProgressDLG', ...
         'Enable','on');

   set(f,'HandleVisibility','callback');
   set(0, 'Units', oldRootUnits);

   ud.CurrINI = CurrINI;
%   ud.position = get(f,'Position');
%   set(f,'Position',[0 0 1 1]);
   set(f,'Visible','on');
   drawnow;
end  % case
drawnow;

ud.oldx = oldx;
ud.name = name;
ud.myxlabel = myxlabel;
set(f1,'UserData',ud);

if nargout==1,
  fout = f;
end

%
% end of ProgressDLG.m
%

