function OpenGraphics(GraphDirectory,CurrINI)
% OpenGraphics: Opens a dialog for selecting a graphics file to view and sends the file to the
%               appropriate viewer
%
% USAGE:
%
%       OpenGraphics(GraphDirectory,CurrINI)
%
% OPTIONAL INPUT: GraphDirectory (string vector) being a valid file directory.
%
%                 CurrINI (structure), with initialization information.
%
%
% NOTE: The OpenGrpahics function can open any file for which the "open" command is registered. You can
%       check this by right-clicking on a file in Windows Explorer and see if the "open" command appears
%       on the context menu.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 21, 2006.
%                        This version: December 8, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 22-8-2006:  Fixed a bug in the FileName cell array.
%
% * 29-8-2006:  Added the CurrINI input and added the call to SetToolbarImages for fig-files.
%
% * 17-10-2006: Added a try, catch call when attempting to load fig-files. This is needed if matlab can't
%               read the fig-file, e.g., because it was created with a later version of matlab.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 22-9-2008:  Added a check if the file shellcmd.exe exists.
%
% * 8-12-2008:  Added quotes around the calls to exe-files.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin==0;
   maingui = findobj('Type','figure','Tag','YADA');
   controls = get(maingui,'UserData');
   CurrINI = get(controls.filemenu,'UserData');
   DSGEModel = get(controls.open,'UserData');
   GraphDirectory = [DSGEModel.OutputDirectory '\graphs'];
   if DirExist(GraphDirectory)==0;
      GraphDirectory = pwd;
   end;
end;

if MatlabNumber>=6;
   FileName = {'*.fig', 'Matlab Figure Files (*.fig)'; ...
              '*.pdf', 'Portable Document Format Files (*.pdf)'; ...
              '*.emf', 'Windows Meta Files (*.emf)'; ...
              '*.jpg;*.jpeg', 'Jpeg Files (*.jpg, *.jpeg)'; ...
              '*.png', 'Portable Network Graphics Files (*.png)'; ...
              '*.eps', 'Encapsulated PostScript Files (*.eps)'; ...
              '*.*', 'All Files (*.*)'};
   [fname,fpath] = uigetfile(FileName,'Open Graphics File',[GraphDirectory '\']);
else;
   FileName = [GraphDirectory '\*.fig;*.pdf;*.emf;*jpg;*.png;*.eps'];
   [fname,fpath] = uigetfile(FileName,'Open Graphics File');
end;
drawnow;
drawnow;
if (isnumeric(fname)==0)&(FileExist([fpath fname])==1);
   file = [fpath fname];
   if strcmp(lower(GetExt(file)),'.fig')==1;
      ErrorStr = '';
      try;
         open(file);
      catch;
         ErrorStr = ['Unable to load the file "' GetFilename(file) '". Message caught is: ' lasterr];
      end;
      if isempty(ErrorStr)==1;
         set(gcf,'Visible','off');
         SetToolbarImages(gcf,CurrINI.images);
         set(gcf,'Visible','on');
      else;
         About(ErrorStr,'information','YADA - Bad FIG File',160,500,CurrINI);
      end;
   else;
      %
      % use the shellcmd function
      %
      if FileExist([pwd '\bin\shellcmd.exe'])==1;
         cmd = ['"' pwd '\bin\shellcmd.exe" "' file '"'];
      else;
         cmd = ['"' file '" &'];
      end;
      stat = dos(cmd);
   end;
end;

%
% end of OpenGraphics.m
%
