function OutThreeDMat = MakeTrans(ThreeDMat,OldColor,NewColor)
% MakeTrans: Replaces colors (1x3 vectors) in a 3D matrix with
%            valid CData.
%
% USAGE:
%
%       OutThreeDMat = MakeTrans(ThreeDMat,OldColor,NewColor)
%
% REQUIRED INPUT:  ThreeDMat (matrix) of dimension nxmx3 with values between 0 and 1.
%
%                  OldColor (vector) of dimension 3 with values between 0 and 1.
%
%                  NewColor (vector) of dimension 3 with values between 0 and 1 or NaN.
%
% REQUIRED OUTPUT: OutThreeDMat (matrix) of dimension nxmx3 with values between 0 and 1.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 21, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 20-5-2008:  Updated the documentation and optimized the code.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

n = size(ThreeDMat,1);
m = size(ThreeDMat,2);
%
NewColor = round(255*NewColor);
%
for i=1:3;
   for j=1:n;
      for k=1:m;
         if ThreeDMat(j,k,i)==OldColor(i);
            ThreeDMat(j,k,i) = NewColor(i);
         end;
      end;
   end;
end;
%
% divide by 255 to make sure that the entries are between 0 and 1
%
OutThreeDMat = ThreeDMat/255;

%
% end of MakeTrans.m
%
