function controls = MakeModelFilesMenu(controls,ModelFiles,CurrentModel,FcnName,FcnCallback)
% MakeModelFilesMenu: Sets up menu item for loading models.
%
% USAGE:
%
%       controls = MakeModelFilesMenu(controls,ModelFiles,CurrentModel,FcnName,FcnCallback)
%
% REQUIRED INPUT:  controls (structure) with handles to controls on the YADA dialog.
%
%                  ModelFiles (string matrix) where the rows give the full paths and names
%                             for DSGE model files.
%
%                  CurrentModel (string vector with the name of the current model.
%
%                  FcnName (string vector) with the function to set the callback string to.
%
%                  FcnCallback (string vector) with the input for the FcnName function.
%
% REQUIRED OUTPUT: controls (structure) with handles to controls on the YADA dialog.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: January 24, 2007.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 25-1-2007:  Finished the function.
%
% * 26-1-2007:  Added the accelerator keys.
%
% * 9-11-2007:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Udpated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

DeleteObjects = findobj('Parent',controls.reopenmenu);
if isempty(DeleteObjects)==0;
   delete(DeleteObjects);
end;
%
for i=1:min(size(ModelFiles,1),10);
   if i<10;
      MenuHandle = uimenu('Parent',controls.reopenmenu, ...
                          'Label',['&' num2str(i,'%0.0f') '. ' GetFilename(StringTrim(ModelFiles(i,:)))], ...
                          'Enable','on', ...
                          'Accelerator',num2str(i,'%0.0f'), ...
                          'CallBack',[FcnName ' ' FcnCallback], ...
                          'UserData',StringTrim(ModelFiles(i,:)), ...
                          'Tag',['Model' num2str(i,'%0.0f') 'Menu']);
   elseif i==10;
      MenuHandle = uimenu('Parent',controls.reopenmenu, ...
                          'Label',['1&0. ' GetFilename(StringTrim(ModelFiles(i,:)))], ...
                          'Enable','on', ...
                          'Accelerator','0', ...
                          'CallBack',[FcnName ' ' FcnCallback], ...
                          'UserData',StringTrim(ModelFiles(i,:)), ...
                          'Tag',['Model' num2str(i,'%0.0f') 'Menu']);
   end;
   if strcmp(lower(CurrentModel),lower(StringTrim(ModelFiles(i,:))))==1;
      set(MenuHandle,'Checked','on');
   end;
   controls = setfield(controls,['openmodel' num2str(i,'%0.0f')],MenuHandle);
end;

%
% end of MakeModelFilesMenu.m
%
